/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.drafts.Draft_75;
import org.java_websocket.drafts.Draft_76;
import org.java_websocket.handshake.ServerHandshake;
import playn.core.Net;
import playn.core.Platform;

public class JavaWebSocket
implements Net.WebSocket {
    private final WebSocketClient socket;

    public JavaWebSocket(final Platform platform, String uri, final Net.WebSocket.Listener listener, int draft) {
        URI juri = null;
        try {
            juri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket = new WebSocketClient(juri, this.useDraft(draft)){

            public void onMessage(final ByteBuffer buffer) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onDataMessage(buffer);
                    }
                });
            }

            public void onMessage(final String msg) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onTextMessage(msg);
                    }
                });
            }

            public void onError(final Exception e) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onError(e.getMessage());
                    }
                });
            }

            public void onClose(int arg0, String arg1, boolean arg2) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onClose();
                    }
                });
            }

            public void onOpen(ServerHandshake handshake) {
                platform.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.onOpen();
                    }
                });
            }
        };
        this.socket.connect();
    }

    public void close() {
        this.socket.close();
    }

    public void send(String data) {
        try {
            this.socket.getConnection().send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void send(ByteBuffer data) {
        try {
            this.socket.getConnection().send(data);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Draft useDraft(int draft) {
        switch (draft) {
            case 17: {
                return new Draft_17();
            }
            case 75: {
                return new Draft_75();
            }
            case 76: {
                return new Draft_76();
            }
        }
        return new Draft_10();
    }
}

