/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.graphql_java_generator.client.GraphQLObjectMapper;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.response.Error;
import com.graphql_java_generator.client.response.JsonResponseWrapper;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class GraphQLReactiveWebSocketHandler
implements WebSocketHandler {
    private static Logger logger = LoggerFactory.getLogger(GraphQLReactiveWebSocketHandler.class);
    private static final List<String> SUB_PROTOCOL_LIST = Arrays.asList("graphql-transport-ws");
    private int lastUsedUniqueIdOperation = 0;
    final GraphQLObjectMapper objectMapper;
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    WebSocketSession session = null;
    SubscriptionRequestEmitter webSocketEmitter = null;
    CountDownLatch webSocketConnectionInitializationLatch = new CountDownLatch(1);
    Throwable initializationError = null;
    Map<String, RequestData<?, ?>> registeredSubscriptions = new ConcurrentHashMap();

    public GraphQLReactiveWebSocketHandler(GraphQLObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> String executeSubscription(Map<String, Object> request, String subscriptionName, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messsageType) throws GraphQLRequestExecutionException {
        RequestData<R, T> subData;
        this.checkInitializationError();
        Map<String, RequestData<?, ?>> map = this.registeredSubscriptions;
        synchronized (map) {
            subData = new RequestData<R, T>(request, subscriptionName, subscriptionCallback, subscriptionType, messsageType, ++this.lastUsedUniqueIdOperation);
            this.registeredSubscriptions.put(subData.uniqueIdOperation, subData);
        }
        logger.trace("Emitting execution of the subscription id={} on the web socket {} (request={})", new Object[]{subData.uniqueIdOperation, this.session, request});
        this.webSocketEmitter.emit(subData, this.session.textMessage(this.encode(subData.uniqueIdOperation, MessageType.SUBSCRIBE, subData.request)));
        return subData.uniqueIdOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends GraphQLRequestObject> R executeQueryOrMutation(Map<String, Object> request, Class<R> requestType) throws GraphQLRequestExecutionException {
        RequestData subData;
        QueryOrMutationCallback callback = new QueryOrMutationCallback();
        this.checkInitializationError();
        Map<String, RequestData<?, ?>> map = this.registeredSubscriptions;
        synchronized (map) {
            subData = new RequestData(request, null, callback, requestType, requestType, ++this.lastUsedUniqueIdOperation);
            this.registeredSubscriptions.put(subData.uniqueIdOperation, subData);
        }
        logger.trace("Emitting execution of the subscription id={} on the web socket {} (request={})", new Object[]{subData.uniqueIdOperation, this.session, request});
        this.webSocketEmitter.emit(subData, this.session.textMessage(this.encode(subData.uniqueIdOperation, MessageType.SUBSCRIBE, subData.request)));
        int nbSecondsTimeOut = 30;
        try {
            callback.latchResponseOrExceptionReceived.await(nbSecondsTimeOut, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new GraphQLRequestExecutionException("Got interrupted while waiting for request response", (Throwable)e);
        }
        if (callback.exceptions.size() > 0) {
            throw new GraphQLRequestExecutionException("An error occurred while processing the request: " + callback.exceptions.get(0).getMessage(), callback.exceptions.get(0));
        }
        if (callback.response != null) {
            return (R)((GraphQLRequestObject)callback.response);
        }
        throw new GraphQLRequestExecutionException("Received no answer after " + nbSecondsTimeOut + " seconds");
    }

    public void unsubscribe(String uniqueIdOperation) throws GraphQLRequestExecutionException {
        logger.trace("Emitting 'complete' message to close the subscription for the uniqueIdOperation={} on socket {}", (Object)uniqueIdOperation, (Object)this.session);
        RequestData<?, ?> subData = this.registeredSubscriptions.get(uniqueIdOperation);
        if (subData == null) {
            throw new GraphQLRequestExecutionException("Unknown uniqueIdOperation " + uniqueIdOperation + " for web socket session " + this.session + " when trying to unsubscribe");
        }
        subData.setCompleted(true);
        this.webSocketEmitter.emit(subData, this.session.textMessage(this.encode(subData.uniqueIdOperation, MessageType.COMPLETE, null)));
    }

    public void checkInitializationError() throws GraphQLRequestExecutionException {
        int nbSecondsTimeOut = 30;
        try {
            this.webSocketConnectionInitializationLatch.await(nbSecondsTimeOut, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new GraphQLRequestExecutionException("The thread got interrupted while waiting for web socket initialization");
        }
        if (this.webSocketConnectionInitializationLatch.getCount() > 0L) {
            throw new GraphQLRequestExecutionException("The session on Web Socket " + this.session + " has not been initialized after " + nbSecondsTimeOut + " seconds");
        }
        if (this.initializationError != null) {
            throw new GraphQLRequestExecutionException("Error during Web Socket or Subscription initialization: " + this.initializationError.getClass().getSimpleName() + "-" + this.initializationError.getMessage(), this.initializationError);
        }
    }

    void setInitializationError(Throwable initializationError) {
        this.initializationError = initializationError;
        this.webSocketConnectionInitializationLatch.countDown();
    }

    public Mono<Void> handle(WebSocketSession sessionParam) {
        this.session = sessionParam;
        logger.trace("new web socket session received: {}", (Object)this.session);
        Mono input = this.session.receive().doOnNext(message -> this.onNext((WebSocketMessage)message)).doOnError(t -> this.onError((Throwable)t)).doOnComplete(() -> this.onComplete()).then();
        Mono output = this.session.send((Publisher)Flux.push(sink -> {
            sink.next((Object)this.session.textMessage(this.encode(null, MessageType.CONNECTION_INIT, null)));
            logger.trace("The 'connection_init' message has been written on the web socket {}", (Object)this.session);
            this.webSocketEmitter = new SubscriptionRequestEmitter((FluxSink)sink){
                final /* synthetic */ FluxSink val$sink;
                {
                    this.val$sink = fluxSink;
                }

                @Override
                public synchronized void emit(RequestData<?, ?> subData, WebSocketMessage msg) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Emitting message for uniqueIdOperation {} on web socket {}: {}", new Object[]{subData.uniqueIdOperation, GraphQLReactiveWebSocketHandler.this.session, msg.getPayloadAsText()});
                    }
                    this.val$sink.next((Object)msg);
                    if (!subData.isCompleted()) {
                        subData.onSubscriptionExecuted();
                    }
                }
            };
        }).doOnError(t -> {
            this.initializationError = t;
        }));
        logger.trace("End of handle(session {}) method execution", (Object)this.session);
        return Mono.zip((Mono)input, (Mono)output).then();
    }

    public void onNext(WebSocketMessage message) {
        String type;
        MessageType messageType;
        Map map;
        try {
            map = this.objectMapper.readValue(message.getPayloadAsText(), HashMap.class);
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException("Error while reading '" + message.getPayloadAsText() + "' as a Map", e2);
        }
        String id = (String)map.get("id");
        RequestData<?, ?> subData = null;
        if (id != null) {
            subData = this.registeredSubscriptions.get(id);
        }
        if ((messageType = MessageType.resolve(type = (String)map.get("type"))) == null) {
            GraphQlStatus.closeSession(this, this.session, GraphQlStatus.INVALID_MESSAGE_STATUS, "Invalid message: " + message.getPayloadAsText());
            return;
        }
        switch (messageType) {
            case CONNECTION_ACK: {
                logger.trace("Received 'connection_ack' on web socket {}", (Object)this.session);
                this.webSocketConnectionInitializationLatch.countDown();
                break;
            }
            case NEXT: {
                if (logger.isTraceEnabled()) {
                    logger.trace("Received 'next' for id {} on web socket {} (payload={})", new Object[]{id, this.session, message.getPayloadAsText()});
                }
                if (id == null) {
                    GraphQlStatus.closeSession(this, this.session, GraphQlStatus.INVALID_MESSAGE_STATUS, "Invalid message (id is null): " + message.getPayloadAsText());
                    return;
                }
                if (subData == null) {
                    logger.warn("[graphql-transport-ws] Unknown uniqueIdOperation {} for web socket session {} (a 'complete' message is sent to the server to that he stops managing this uniqueIdOperation)", (Object)id, (Object)this.session);
                    this.webSocketEmitter.emit(subData, this.session.textMessage(this.encode(id, MessageType.COMPLETE, null)));
                    break;
                }
                if (subData.isCompleted()) {
                    logger.warn("Receive a message for a closed uniqueIdOperation ({}) on web socket {}", (Object)id, (Object)this.session);
                    break;
                }
                if (map.get("payload") == null) {
                    String msg = "payload is mandatory for 'next' messages";
                    logger.error(msg);
                    subData.onError(new GraphQLRequestExecutionException(msg));
                    break;
                }
                if (!(map.get("payload") instanceof Map)) {
                    String msg = "payload should be a Map, but <" + map.get("payload") + "> is not a Map";
                    logger.error(msg);
                    subData.onError(new GraphQLRequestExecutionException(msg));
                    break;
                }
                subData.onNext((Map)map.get("payload"));
                break;
            }
            case COMPLETE: {
                logger.trace("Received 'complete' for id {} on web socket {} (payload={})", new Object[]{id, this.session, message});
                subData.onComplete();
                break;
            }
            case ERROR: {
                logger.warn("Received 'error' for id {} on web socket {} (payload={})", new Object[]{id, this.session, message.getPayloadAsText()});
                if (map.get("payload") instanceof Map) {
                    String msg = (String)((Map)map.get("payload")).get("message");
                    subData.onError(new GraphQLRequestExecutionException(msg));
                    break;
                }
                List errors = (List)map.get("payload");
                List errorMessages = errors.stream().map(e -> (String)e.get("message")).collect(Collectors.toList());
                subData.onError(new GraphQLRequestExecutionException(errorMessages));
                break;
            }
            default: {
                logger.warn("Received non managed message '{}' for id {} on web socket {} (payload={})", new Object[]{type, id, this.session, message});
                String msg = "Non managed message type '" + type + "'";
                if (subData != null) {
                    subData.onError(new GraphQLRequestExecutionException(msg));
                    break;
                }
                logger.error(msg);
            }
        }
    }

    public void onError(Throwable t) {
        if (t == null) {
            t = new RuntimeException("Unknown exception");
            logger.error("The Web Socket session {} ended with an unknown error", (Object)this.session);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("The Web Socket session ").append(this.session).append(" ended with an error (").append(t.getClass().getSimpleName()).append(t.getMessage()).append(")");
            for (StackTraceElement row : t.getStackTrace()) {
                sb.append("\n    ").append(row);
            }
            logger.error(sb.toString());
        }
        for (RequestData<?, ?> subData : this.registeredSubscriptions.values()) {
            subData.onError(t);
        }
        if (this.session != null) {
            this.session.close(CloseStatus.SERVER_ERROR);
            this.session = null;
        }
    }

    public void onComplete() {
        logger.trace("onComplete received for WebSocketSession {}", (Object)this.session);
        for (RequestData<?, ?> subData : this.registeredSubscriptions.values()) {
            subData.onComplete();
        }
    }

    public List<String> getSubProtocols() {
        return SUB_PROTOCOL_LIST;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    String encode(@Nullable String id, MessageType messageType, @Nullable Object payload) {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>(3);
        payloadMap.put("type", messageType.getType());
        if (id != null) {
            payloadMap.put("id", id);
        }
        if (payload != null) {
            payloadMap.put("payload", payload);
        }
        try {
            return this.objectMapper.writeValueAsString(payloadMap);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write " + payloadMap + " as JSON", ex);
        }
    }

    static interface SubscriptionRequestEmitter {
        public void emit(RequestData<?, ?> var1, WebSocketMessage var2);
    }

    class RequestData<R, T> {
        final String uniqueIdOperation;
        final Map<String, Object> request;
        final String subscriptionName;
        final SubscriptionCallback<T> subscriptionCallback;
        final Class<R> subscriptionType;
        final Class<T> messageType;
        boolean completed = false;

        RequestData(Map<String, Object> request, String subscriptionName, SubscriptionCallback<T> subscriptionCallback, Class<R> requestType, Class<T> messageType, int uniqueIdOperation) throws GraphQLRequestExecutionException {
            this.request = request;
            this.subscriptionName = subscriptionName;
            this.subscriptionCallback = subscriptionCallback;
            this.subscriptionType = requestType;
            this.messageType = messageType;
            this.uniqueIdOperation = Integer.toString(uniqueIdOperation);
            if (subscriptionName == null && requestType != messageType) {
                throw new GraphQLRequestExecutionException("[Internal error] When executing query or mutation, T and R should be equal. But R (requestType) is " + requestType.getName() + " and T (messsageType) is " + messageType.getName());
            }
        }

        public void onNext(Map<String, Object> result) {
            if (this.completed) {
                logger.trace("Message received for a subscription of id {} from the Web Socket session {}, but the operation {} has already completed (the message was {})", new Object[]{this.uniqueIdOperation, GraphQLReactiveWebSocketHandler.this.session, this.uniqueIdOperation, result});
            } else {
                logger.trace("Message received for a subscription of id {}, from the Web Socket: {} (on session {})", new Object[]{this.uniqueIdOperation, result, GraphQLReactiveWebSocketHandler.this.session});
                JsonResponseWrapper response = GraphQLReactiveWebSocketHandler.this.objectMapper.convertValue(result, JsonResponseWrapper.class);
                if (response.errors != null && response.errors.size() > 0) {
                    ArrayList<String> errMessages = null;
                    if (response.errors == null) {
                        logger.error("Unknwon error received from the GraphQL server for subscription " + this.uniqueIdOperation);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("An error has been received from the GraphQL server for subscription ");
                        sb.append(this.uniqueIdOperation);
                        sb.append(": ");
                        errMessages = new ArrayList<String>();
                        for (Error err : response.errors) {
                            errMessages.add(err.message);
                            if (errMessages.size() > 0) {
                                sb.append(" | ");
                            }
                            sb.append(err.message);
                        }
                        logger.error(sb.toString());
                    }
                    this.subscriptionCallback.onError(new GraphQLRequestExecutionException(errMessages));
                } else {
                    R r = GraphQLReactiveWebSocketHandler.this.objectMapper.convertValue((Object)response.data, this.subscriptionType);
                    if (this.subscriptionName != null) {
                        Object t = GraphQLReactiveWebSocketHandler.this.graphqlUtils.invokeGetter(r, this.subscriptionName);
                        this.subscriptionCallback.onMessage(t);
                    } else {
                        R t = r;
                        this.subscriptionCallback.onMessage(t);
                    }
                }
            }
        }

        public void onError(Throwable t) {
            if (this.completed) {
                logger.trace("Error received from the Web Socket session {}, but the operation {} has already completed", (Object)GraphQLReactiveWebSocketHandler.this.session, (Object)this.uniqueIdOperation);
            } else {
                logger.trace("Error received for WebSocketSession {}: {}", (Object)GraphQLReactiveWebSocketHandler.this.session, (Object)t.getMessage());
                this.subscriptionCallback.onError(t);
            }
        }

        public void onClose(int statusCode, String reason) {
            if (this.completed) {
                logger.trace("'Close' received from the Web Socket session {}, but the operation {} has already completed (status={}, reason={})", new Object[]{GraphQLReactiveWebSocketHandler.this.session, this.uniqueIdOperation, reason, GraphQLReactiveWebSocketHandler.this.session});
            } else {
                logger.trace("onClose(code={}, reason={}) received for WebSocketSession {}: {}", new Object[]{statusCode, reason, GraphQLReactiveWebSocketHandler.this.session});
                this.subscriptionCallback.onClose(statusCode, reason);
            }
        }

        public void onComplete() {
            if (this.completed) {
                logger.trace("Complete received from the Web Socket session {}, but the operation {} has already completed", (Object)GraphQLReactiveWebSocketHandler.this.session, (Object)this.uniqueIdOperation);
            } else {
                logger.trace("onComplete received for id {} on WebSocketSession {}", (Object)this.uniqueIdOperation, (Object)GraphQLReactiveWebSocketHandler.this.session);
                this.subscriptionCallback.onClose(0, "Complete");
            }
        }

        public void onSubscriptionExecuted() {
            if (this.completed) {
                logger.trace("Subscribe received from the Web Socket session {}, but the operation {} has already completed", (Object)GraphQLReactiveWebSocketHandler.this.session, (Object)this.uniqueIdOperation);
            } else {
                this.subscriptionCallback.onConnect();
            }
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }
    }

    public static enum MessageType {
        CONNECTION_INIT("connection_init"),
        CONNECTION_ACK("connection_ack"),
        SUBSCRIBE("subscribe"),
        NEXT("next"),
        ERROR("error"),
        COMPLETE("complete"),
        START("start");

        private static final Map<String, MessageType> messageTypes;
        private final String type;

        private MessageType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public static MessageType resolve(@Nullable String type) {
            return type != null ? messageTypes.get(type) : null;
        }

        static {
            messageTypes = new HashMap<String, MessageType>(6);
            for (MessageType messageType : MessageType.values()) {
                messageTypes.put(messageType.getType(), messageType);
            }
        }
    }

    private static class QueryOrMutationCallback<R>
    implements SubscriptionCallback<R> {
        CountDownLatch latchResponseOrExceptionReceived = new CountDownLatch(1);
        R response = null;
        List<Throwable> exceptions = new ArrayList<Throwable>();

        private QueryOrMutationCallback() {
        }

        @Override
        public void onConnect() {
        }

        @Override
        public void onMessage(R r) {
            this.response = r;
            this.latchResponseOrExceptionReceived.countDown();
        }

        @Override
        public void onClose(int statusCode, String reason) {
            if (this.response == null) {
                this.exceptions.add(new GraphQLRequestExecutionException("Received onClose while expecting a message (status=" + statusCode + ", reason=" + reason + ")"));
            }
            this.latchResponseOrExceptionReceived.countDown();
        }

        @Override
        public void onError(Throwable cause) {
            this.exceptions.add(cause);
            this.latchResponseOrExceptionReceived.countDown();
        }
    }

    private static class GraphQlStatus {
        private static final CloseStatus INVALID_MESSAGE_STATUS = new CloseStatus(4400, "Invalid message");
        private static final CloseStatus UNAUTHORIZED_STATUS = new CloseStatus(4401, "Unauthorized");
        private static final CloseStatus INIT_TIMEOUT_STATUS = new CloseStatus(4408, "Connection initialisation timeout");
        private static final CloseStatus TOO_MANY_INIT_REQUESTS_STATUS = new CloseStatus(4429, "Too many initialisation requests");

        private GraphQlStatus() {
        }

        static void closeSession(GraphQLReactiveWebSocketHandler handler, WebSocketSession session, CloseStatus status, String reason) {
            for (RequestData<?, ?> subData : handler.registeredSubscriptions.values()) {
                subData.onClose(status.getCode(), reason == null ? status.getReason() : reason);
            }
            session.close(status);
        }
    }
}

