/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.client.response.GraphQLRequestPreparationException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GraphqlUtils {
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    List<Class<?>> scalars = new ArrayList();

    public GraphqlUtils() {
        this.scalars.add(String.class);
        this.scalars.add(Integer.TYPE);
        this.scalars.add(Integer.class);
        this.scalars.add(Float.TYPE);
        this.scalars.add(Float.class);
        this.scalars.add(Boolean.TYPE);
        this.scalars.add(Boolean.class);
    }

    public void checkName(String graphqlIdentifier) throws GraphQLRequestPreparationException {
        if (graphqlIdentifier == null) {
            throw new NullPointerException("A GraphQL identifier may not be null");
        }
        Matcher m = this.graphqlNamePattern.matcher(graphqlIdentifier);
        if (!m.matches()) {
            throw new GraphQLRequestPreparationException("<" + graphqlIdentifier + "> is not a valid GraphQL name");
        }
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> checkFieldOfGraphQLType(String name, Boolean shouldBeScalar, Class<?> owningClass) throws GraphQLRequestPreparationException {
        this.checkName(name);
        Class<?> fieldClass = null;
        for (Field field : owningClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            fieldClass = this.checkIsScalar(field, shouldBeScalar);
            break;
        }
        if (fieldClass == null && !owningClass.isInterface()) {
            for (AccessibleObject accessibleObject : owningClass.getDeclaredMethods()) {
                if (!((Method)accessibleObject).getName().equals(name)) continue;
                fieldClass = this.checkIsScalar(name, (Method)accessibleObject, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null && owningClass.isInterface()) {
            void var8_13;
            String expectedMethodName = "get" + this.getPascalCase(name);
            Method[] methodArray = owningClass.getDeclaredMethods();
            int n = methodArray.length;
            boolean bl = false;
            while (var8_13 < n) {
                Method method = methodArray[var8_13];
                if (method.getName().equals(expectedMethodName)) {
                    fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                    break;
                }
                ++var8_13;
            }
        }
        if (fieldClass == null) {
            throw new GraphQLRequestPreparationException("The GraphQL type <" + owningClass.getSimpleName() + "> has no field of name <" + name + ">");
        }
        return fieldClass;
    }

    String getPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    Class<?> checkIsScalar(Field field, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(field);
        if (shouldBeScalar != null) {
            if (shouldBeScalar & !isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the GraphQL type <" + field.getDeclaringClass().getName() + "> is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
            if (shouldBeScalar == false & isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the GraphQL type <" + field.getDeclaringClass().getName() + "> is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
        }
        return this.getGraphQLType(field);
    }

    Class<?> checkIsScalar(String fieldName, Method method, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(method);
        if (method.getReturnType() == null) {
            throw new GraphQLRequestPreparationException("There is a method of name <" + fieldName + "> in the GraphQL type <" + method.getDeclaringClass().getName() + ">, but this method is a void method: it can't represent the <" + fieldName + "> GraphQL field");
        }
        if (shouldBeScalar != null) {
            if (shouldBeScalar.booleanValue() && !isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + fieldName + "> (accessed through its getter: " + method.getName() + ">) of the GraphQL type <" + method.getDeclaringClass().getName() + "> should be a scalar. But is is actually not a GraphQLScalar");
            }
            if (!shouldBeScalar.booleanValue() && isScalar) {
                throw new GraphQLRequestPreparationException("The field <" + fieldName + "> (accessed through its getter: <" + method.getName() + ">) of the GraphQL type <" + method.getDeclaringClass().getName() + "> should not be a scalar. But is is actually a GraphQLScalar");
            }
        }
        return this.getGraphQLType(method);
    }

    public boolean isScalar(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null || fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class) != null;
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the class <" + field.getDeclaringClass().getName() + "> has none of the GraphQLScalar and GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method <" + method.getName() + "> of the class <" + method.getDeclaringClass().getName() + "> has none of the GraphQLScalar and GraphQLNonScalar annotation");
    }

    public Class<?> getGraphQLType(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class).graphqlType();
        }
        if (fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLNonScalar.class).graphqlType();
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field <" + field.getName() + "> of the class <" + field.getDeclaringClass().getName() + "> has none of the GraphQLScalar and GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method <" + method.getName() + "> of the class <" + method.getDeclaringClass().getName() + "> has none of the GraphQLScalar and GraphQLNonScalar annotation");
    }
}

