/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.response;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.GraphQLScalarType;
import java.io.IOException;

public class AbstractCustomScalarDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;
    final GraphQLScalarType graphQLScalarType;

    protected AbstractCustomScalarDeserializer(Class<?> handledType, GraphQLScalarType graphQLScalarType) {
        super(handledType);
        this.graphQLScalarType = graphQLScalarType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        FloatValue value;
        switch (p.currentToken()) {
            case VALUE_NUMBER_FLOAT: {
                value = new FloatValue(p.getDecimalValue());
                break;
            }
            case VALUE_NUMBER_INT: {
                value = new IntValue(p.getBigIntegerValue());
                break;
            }
            case VALUE_STRING: {
                value = new StringValue(p.getText());
                break;
            }
            default: {
                throw new JsonParseException(p, "Non managed JSON token: " + p.currentToken());
            }
        }
        return (T)this.graphQLScalarType.getCoercing().parseLiteral((Object)value);
    }
}

