/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.annotations.TypeFunction;
import graphql.schema.GraphQLType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public class BatchedTypeFunction
implements TypeFunction {
    private TypeFunction defaultTypeFunction;

    public BatchedTypeFunction(TypeFunction defaultTypeFunction) {
        this.defaultTypeFunction = defaultTypeFunction;
    }

    @Override
    public String getTypeName(Class<?> aClass, AnnotatedType annotatedType) {
        return this.defaultTypeFunction.getTypeName(aClass, annotatedType);
    }

    @Override
    public boolean canBuildType(Class<?> aClass, AnnotatedType type) {
        return this.defaultTypeFunction.canBuildType(aClass, type);
    }

    @Override
    public GraphQLType buildType(String typeName, Class<?> aClass, AnnotatedType annotatedType) {
        if (!aClass.isAssignableFrom(List.class)) {
            throw new IllegalArgumentException("Batched method should return a List");
        }
        if (!(annotatedType instanceof AnnotatedParameterizedType)) {
            throw new IllegalArgumentException("Batched should return parameterized type");
        }
        AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
        AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
        Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
        return this.defaultTypeFunction.buildType(typeName, klass, arg);
    }
}

