/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase.auth;

import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.jdroid.java.exception.UnexpectedException;
import java.util.concurrent.CountDownLatch;

public abstract class FirebaseAuthenticationStrategy
implements Firebase.AuthResultHandler {
    private CountDownLatch countDownLatch;

    public final void authenticate(Firebase firebase) {
        this.countDownLatch = new CountDownLatch(1);
        this.doAuthenticate(firebase);
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected abstract void doAuthenticate(Firebase var1);

    protected void doOnAuthenticationError(FirebaseError error) {
        throw new UnexpectedException(error.getMessage());
    }

    protected void doOnAuthenticated(AuthData authData) {
    }

    public final void onAuthenticationError(FirebaseError error) {
        this.getCountDownLatch().countDown();
        this.doOnAuthenticationError(error);
    }

    public final void onAuthenticated(AuthData authData) {
        this.getCountDownLatch().countDown();
        this.doOnAuthenticated(authData);
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }
}

