/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jdroid.github.client.DateFormatter;
import com.jdroid.github.client.EventFormatter;
import com.jdroid.github.event.Event;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;

public abstract class GsonUtils {
    private static final Gson GSON = GsonUtils.createGson(true);
    private static final Gson GSON_NO_NULLS = GsonUtils.createGson(false);

    public static final Gson createGson() {
        return GsonUtils.createGson(true);
    }

    public static final Gson createGson(boolean serializeNulls) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new DateFormatter());
        builder.registerTypeAdapter(Event.class, (Object)new EventFormatter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        if (serializeNulls) {
            builder.serializeNulls();
        }
        return builder.create();
    }

    public static final Gson getGson() {
        return GSON;
    }

    public static final Gson getGson(boolean serializeNulls) {
        return serializeNulls ? GSON : GSON_NO_NULLS;
    }

    public static final String toJson(Object object) {
        return GsonUtils.toJson(object, true);
    }

    public static final String toJson(Object object, boolean includeNulls) {
        return includeNulls ? GSON.toJson(object) : GSON_NO_NULLS.toJson(object);
    }

    public static final <V> V fromJson(String json, Class<V> type) {
        return (V)GSON.fromJson(json, type);
    }

    public static final <V> V fromJson(String json, Type type) {
        return (V)GSON.fromJson(json, type);
    }

    public static final <V> V fromJson(Reader reader, Class<V> type) {
        return (V)GSON.fromJson(reader, type);
    }

    public static final <V> V fromJson(Reader reader, Type type) {
        return (V)GSON.fromJson(reader, type);
    }
}

