/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.client;

import com.jdroid.github.client.GitHubRequest;
import com.jdroid.github.util.UrlUtils;

public class PagedRequest<V>
extends GitHubRequest {
    public static final int PAGE_FIRST = 1;
    public static final int PAGE_SIZE = 100;
    private final int pageSize;
    private final int page;

    public PagedRequest() {
        this(1, 100);
    }

    public PagedRequest(int start, int size) {
        this.page = start;
        this.pageSize = size;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    protected void addParams(StringBuilder uri) {
        int number;
        super.addParams(uri);
        int size = this.getPageSize();
        if (size > 0) {
            UrlUtils.addParam("per_page", Integer.toString(size), uri);
        }
        if ((number = this.getPage()) > 0) {
            UrlUtils.addParam("page", Integer.toString(number), uri);
        }
    }

    public int getPage() {
        return this.page;
    }
}

