/******************************************************************************
 *  Copyright (c) 2011 GitHub Inc.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *    Kevin Sawicki (GitHub Inc.) - initial API and implementation
 *****************************************************************************/
package com.jdroid.github;

import java.io.Serializable;

/**
 * Authorized application model class
 */
public class Application implements Serializable {

	/** serialVersionUID */
	private static final long serialVersionUID = 5675660442127228497L;

	private String name;

	private String url;

	/**
	 * @return name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 * @return this application
	 */
	public Application setName(String name) {
		this.name = name;
		return this;
	}

	/**
	 * @return url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @param url
	 * @return this application
	 */
	public Application setUrl(String url) {
		this.url = url;
		return this;
	}
}
