/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.service;

import com.google.gson.reflect.TypeToken;
import com.jdroid.github.IRepositoryIdProvider;
import com.jdroid.github.Repository;
import com.jdroid.github.User;
import com.jdroid.github.client.GitHubClient;
import com.jdroid.github.client.PageIterator;
import com.jdroid.github.client.PagedRequest;
import com.jdroid.github.service.GitHubService;
import java.io.IOException;
import java.util.List;

public class StargazerService
extends GitHubService {
    public StargazerService() {
    }

    public StargazerService(GitHubClient client) {
        super(client);
    }

    protected PagedRequest<User> createStargazerRequest(IRepositoryIdProvider repository, int start, int size) {
        String id = this.getId(repository);
        PagedRequest<User> request = this.createPagedRequest(start, size);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/stargazers");
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return request;
    }

    public List<User> getStargazers(IRepositoryIdProvider repository) throws IOException {
        PagedRequest<User> request = this.createStargazerRequest(repository, 1, 100);
        return this.getAll(request);
    }

    public PageIterator<User> pageStargazers(IRepositoryIdProvider repository) {
        return this.pageStargazers(repository, 100);
    }

    public PageIterator<User> pageStargazers(IRepositoryIdProvider repository, int size) {
        return this.pageStargazers(repository, 1, size);
    }

    public PageIterator<User> pageStargazers(IRepositoryIdProvider repository, int start, int size) {
        PagedRequest<User> request = this.createStargazerRequest(repository, start, size);
        return this.createPageIterator(request);
    }

    protected PagedRequest<Repository> createStarredRequest(String user, int start, int size) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        PagedRequest<Repository> request = this.createPagedRequest(start, size);
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/starred");
        request.setUri(uri);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return request;
    }

    protected PagedRequest<Repository> createStarredRequest(int start, int size) {
        PagedRequest<Repository> request = this.createPagedRequest(start, size);
        request.setUri("/user/starred");
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return request;
    }

    public List<Repository> getStarred(String user) throws IOException {
        PagedRequest<Repository> request = this.createStarredRequest(user, 1, 100);
        return this.getAll(request);
    }

    public PageIterator<Repository> pageStarred(String user) throws IOException {
        return this.pageStarred(user, 100);
    }

    public PageIterator<Repository> pageStarred(String user, int size) throws IOException {
        return this.pageStarred(user, 1, size);
    }

    public PageIterator<Repository> pageStarred(String user, int start, int size) throws IOException {
        PagedRequest<Repository> request = this.createStarredRequest(user, start, size);
        return this.createPageIterator(request);
    }

    public List<Repository> getStarred() throws IOException {
        PagedRequest<Repository> request = this.createStarredRequest(1, 100);
        return this.getAll(request);
    }

    public PageIterator<Repository> pageStarred() throws IOException {
        return this.pageStarred(100);
    }

    public PageIterator<Repository> pageStarred(int size) throws IOException {
        return this.pageStarred(1, size);
    }

    public PageIterator<Repository> pageStarred(int start, int size) throws IOException {
        PagedRequest<Repository> request = this.createStarredRequest(start, size);
        return this.createPageIterator(request);
    }

    public boolean isStarring(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/starred");
        uri.append('/').append(id);
        return this.check(uri.toString());
    }

    public void star(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/starred");
        uri.append('/').append(id);
        this.client.put(uri.toString());
    }

    public void unstar(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/user");
        uri.append("/starred");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }
}

