/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.api;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.http.HttpWebServiceProcessor;
import com.jdroid.java.http.MultipartWebService;
import com.jdroid.java.http.Server;
import com.jdroid.java.http.WebService;
import com.jdroid.java.http.cache.Cache;
import com.jdroid.java.http.cache.CachedWebService;
import com.jdroid.java.http.cache.CachingStrategy;
import com.jdroid.java.http.mock.AbstractMockWebService;
import com.jdroid.java.http.post.EntityEnclosingWebService;
import com.jdroid.java.marshaller.MarshallerMode;
import com.jdroid.java.marshaller.MarshallerProvider;
import java.io.File;
import java.util.List;
import java.util.Map;

public abstract class AbstractApiService {
    protected WebService newGetService(Object ... urlSegments) {
        return this.newGetService(false, urlSegments);
    }

    protected WebService newGetService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newGetServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected WebService newCachedGetService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, Object ... urlSegments) {
        WebService webService = this.newGetService(urlSegments);
        return new CachedWebService(webService, cache, cachingStrategy, timeToLive){

            @Override
            protected File getHttpCacheDirectory(Cache cache) {
                return AbstractApiService.this.getHttpCacheDirectory(cache);
            }
        };
    }

    protected abstract WebService newGetServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected EntityEnclosingWebService newPostService(Object ... urlSegments) {
        return this.newPostService(false, urlSegments);
    }

    protected EntityEnclosingWebService newPostService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newPostServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected abstract EntityEnclosingWebService newPostServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected MultipartWebService newMultipartPostService(Object ... urlSegments) {
        return this.newMultipartPostService(false, urlSegments);
    }

    protected MultipartWebService newMultipartPostService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newMultipartPostServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected abstract MultipartWebService newMultipartPostServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected EntityEnclosingWebService newFormPostService(Object ... urlSegments) {
        return this.newFormPostService(false, urlSegments);
    }

    protected EntityEnclosingWebService newFormPostService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newFormPostServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected abstract EntityEnclosingWebService newFormPostServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected EntityEnclosingWebService newPutService(Object ... urlSegments) {
        return this.newPutService(false, urlSegments);
    }

    protected EntityEnclosingWebService newPutService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newPutServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected abstract EntityEnclosingWebService newPutServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected MultipartWebService newMultipartPutService(Object ... urlSegments) {
        return this.newMultipartPutService(false, urlSegments);
    }

    protected MultipartWebService newMultipartPutService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newMultipartPutServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected abstract MultipartWebService newMultipartPutServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected WebService newDeleteService(Object ... urlSegments) {
        return this.newDeleteService(false, urlSegments);
    }

    protected WebService newDeleteService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newDeleteServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected abstract WebService newDeleteServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected EntityEnclosingWebService newPatchService(Object ... urlSegments) {
        return this.newPatchService(false, urlSegments);
    }

    protected EntityEnclosingWebService newPatchService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockWebServiceInstance(urlSegments);
        }
        return this.newPatchServiceImpl(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpWebServiceProcessors());
    }

    protected EntityEnclosingWebService newCachedPatchService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, Object ... urlSegments) {
        EntityEnclosingWebService webService = this.newPutService(urlSegments);
        return new CachedWebService(webService, cache, cachingStrategy, timeToLive){

            @Override
            protected File getHttpCacheDirectory(Cache cache) {
                return AbstractApiService.this.getHttpCacheDirectory(cache);
            }
        };
    }

    protected abstract EntityEnclosingWebService newPatchServiceImpl(Server var1, List<Object> var2, List<HttpWebServiceProcessor> var3);

    protected abstract Server getServer();

    protected List<HttpWebServiceProcessor> getHttpWebServiceProcessors() {
        return this.getServer().getHttpWebServiceProcessors();
    }

    protected abstract AbstractMockWebService getAbstractMockWebServiceInstance(Object ... var1);

    protected abstract Boolean isHttpMockEnabled();

    protected File getHttpCacheDirectory(Cache cache) {
        return null;
    }

    public void marshallSimple(EntityEnclosingWebService webservice, Object object) {
        this.marshall(webservice, object, MarshallerMode.SIMPLE);
    }

    public void marshall(EntityEnclosingWebService webservice, Object object) {
        this.marshall(webservice, object, MarshallerMode.COMPLETE);
    }

    public void marshall(EntityEnclosingWebService webservice, Object object, MarshallerMode mode) {
        this.marshall(webservice, object, mode, null);
    }

    public void marshall(EntityEnclosingWebService webservice, Object object, Map<String, String> extras) {
        this.marshall(webservice, object, MarshallerMode.COMPLETE, extras);
    }

    public void marshall(EntityEnclosingWebService webservice, Object object, MarshallerMode mode, Map<String, String> extras) {
        webservice.setEntity(MarshallerProvider.get().marshall(object, mode, extras).toString());
    }
}

