/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.concurrent;

import com.jdroid.java.concurrent.LowPriorityThreadFactory;
import com.jdroid.java.concurrent.NormalPriorityThreadFactory;
import com.jdroid.java.utils.LoggerUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class ExecutorUtils {
    private static final Logger LOGGER = LoggerUtils.getLogger(ExecutorUtils.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 5;
    private static final Executor fixedExecutor = Executors.newCachedThreadPool(new NormalPriorityThreadFactory());
    private static final Executor fixedLowPriorityExecutor = Executors.newFixedThreadPool(5, new LowPriorityThreadFactory());
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, new NormalPriorityThreadFactory("schedule"));

    public static void execute(Runnable runnable) {
        fixedExecutor.execute(runnable);
    }

    public static void executeWithLowPriority(Runnable runnable) {
        fixedLowPriorityExecutor.execute(runnable);
    }

    public static void schedule(Runnable runnable, Long delaySeconds) {
        scheduledExecutor.schedule(runnable, (long)delaySeconds, TimeUnit.SECONDS);
    }

    public static ScheduledFuture<?> schedule(Runnable runnable, Long delaySeconds, Long period) {
        return scheduledExecutor.scheduleAtFixedRate(runnable, delaySeconds, period, TimeUnit.SECONDS);
    }

    public static void scheduleInMillis(Runnable runnable, Long delayMilliSeconds) {
        scheduledExecutor.schedule(runnable, (long)delayMilliSeconds, TimeUnit.MILLISECONDS);
    }

    public static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            LoggerUtils.logHandledException(LOGGER, e);
        }
    }

    public static void sleepInMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LoggerUtils.logHandledException(LOGGER, e);
        }
    }
}

