/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http;

import com.jdroid.java.utils.LoggerUtils;
import org.slf4j.Logger;

public abstract class HttpResponseWrapper {
    private static final Logger LOGGER = LoggerUtils.getLogger(HttpResponseWrapper.class);

    public abstract String getContent();

    public abstract int getStatusCode();

    public abstract String getStatusReason();

    public abstract String getHeader(String var1);

    public String logStatusCode() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP Status code: ");
        sb.append(this.getStatusCode());
        sb.append(" Reason: ");
        sb.append(this.getStatusReason());
        if (this.isSuccess().booleanValue()) {
            LOGGER.debug(sb.toString());
        } else {
            LOGGER.warn(sb.toString());
        }
        return sb.toString();
    }

    public Boolean isSuccess() {
        int code = this.getStatusCode();
        return code >= 200 && code <= 299;
    }

    public Boolean isClientError() {
        int code = this.getStatusCode();
        return code >= 400 && code <= 499;
    }

    public Boolean isServerError() {
        int code = this.getStatusCode();
        return code >= 500 && code <= 599;
    }
}

