/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.apache;

import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.HttpWebServiceProcessor;
import com.jdroid.java.http.Server;
import com.jdroid.java.http.apache.ApacheHttpWebService;
import com.jdroid.java.http.apache.HttpClientFactory;
import com.jdroid.java.http.post.EntityEnclosingWebService;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public abstract class ApacheHttpEntityEnclosingWebService
extends ApacheHttpWebService
implements EntityEnclosingWebService {
    private HttpEntity entity;

    public ApacheHttpEntityEnclosingWebService(HttpClientFactory httpClientFactory, Server server, List<Object> urlSegments, List<HttpWebServiceProcessor> httpWebServiceProcessors) {
        super(httpClientFactory, server, urlSegments, httpWebServiceProcessors);
    }

    @Override
    protected HttpUriRequest createHttpUriRequest(String url) {
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = this.createHttpEntityEnclosingRequestBase(url);
        this.addEntity(httpEntityEnclosingRequestBase);
        return httpEntityEnclosingRequestBase;
    }

    protected abstract HttpEntityEnclosingRequestBase createHttpEntityEnclosingRequestBase(String var1);

    protected void addEntity(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase) {
        httpEntityEnclosingRequestBase.setEntity(this.entity);
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    @Override
    public void setEntity(String content) {
        try {
            this.entity = new StringEntity(content, "UTF-8");
            ApacheHttpWebService.LOGGER.debug("Entity: " + content);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    public HttpEntity getEntity() {
        return this.entity;
    }
}

