/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.apache;

import com.jdroid.java.http.HttpResponseWrapper;
import com.jdroid.java.utils.FileUtils;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ApacheHttpResponseWrapper
extends HttpResponseWrapper {
    private HttpResponse httpResponse;

    public ApacheHttpResponseWrapper(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String getContent() {
        InputStream inputStream;
        String content;
        block5: {
            content = null;
            inputStream = null;
            try {
                inputStream = this.httpResponse.getEntity() != null ? this.httpResponse.getEntity().getContent() : null;
                Header contentEncoding = this.httpResponse.getFirstHeader("Content-Encoding");
                if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                if (inputStream == null) break block5;
                content = FileUtils.toString(inputStream);
            }
            catch (Exception exception) {
                FileUtils.safeClose(inputStream);
                catch (Throwable throwable) {
                    FileUtils.safeClose(inputStream);
                    throw throwable;
                }
            }
        }
        FileUtils.safeClose(inputStream);
        return content;
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusReason() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    public String getHeader(String name) {
        Header[] headerStatusCode = this.httpResponse.getHeaders(name);
        return headerStatusCode.length > 0 ? headerStatusCode[0].getValue() : null;
    }
}

