/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.apache;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.exception.ConnectionException;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.HttpWebServiceProcessor;
import com.jdroid.java.http.Server;
import com.jdroid.java.http.WebService;
import com.jdroid.java.http.apache.ApacheHttpResponseWrapper;
import com.jdroid.java.http.apache.HttpClientFactory;
import com.jdroid.java.parser.Parser;
import com.jdroid.java.utils.EncodingUtils;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.LoggerUtils;
import com.jdroid.java.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;

public abstract class ApacheHttpWebService
implements WebService {
    protected static final Logger LOGGER = LoggerUtils.getLogger(ApacheHttpWebService.class);
    private Boolean ssl = false;
    private Integer connectionTimeout;
    private String userAgent;
    private Server server;
    private List<Object> urlSegments;
    private Map<String, String> queryParameters = Maps.newLinkedHashMap();
    private Map<String, String> headers = Maps.newHashMap();
    private List<Cookie> cookies = Lists.newArrayList();
    private InputStream inputStream;
    private List<HttpWebServiceProcessor> httpWebServiceProcessors;
    private HttpClientFactory httpClientFactory;

    public ApacheHttpWebService(HttpClientFactory httpClientFactory, Server server, List<Object> urlSegments, List<HttpWebServiceProcessor> httpWebServiceProcessors) {
        this.urlSegments = Lists.newArrayList();
        if (urlSegments != null) {
            for (Object segment : urlSegments) {
                this.addUrlSegment(segment);
            }
        }
        this.httpClientFactory = httpClientFactory;
        this.server = server;
        this.httpWebServiceProcessors = httpWebServiceProcessors;
    }

    public abstract String getMethodName();

    @Override
    public final <T> T execute() {
        return this.execute(null);
    }

    @Override
    public <T> T execute(Parser parser) {
        DefaultHttpClient client = null;
        try {
            if (this.httpWebServiceProcessors != null) {
                for (HttpWebServiceProcessor each : this.httpWebServiceProcessors) {
                    each.beforeExecute(this);
                }
            }
            client = this.httpClientFactory.createHttpClient(this.connectionTimeout, this.userAgent);
            this.addCookies((HttpClient)client);
            HttpUriRequest request = this.createHttpUriRequest(this.getUrl());
            LOGGER.debug(this.getMethodName() + ": " + request.getRequestLine().getUri());
            if (!this.queryParameters.isEmpty()) {
                LOGGER.debug("Query Parameters: " + this.queryParameters.toString());
            }
            if (!this.headers.isEmpty()) {
                LOGGER.debug("Headers: " + this.headers.toString());
            }
            this.addHeaders(request);
            HttpResponse httpResponse = client.execute(request);
            if (this.httpWebServiceProcessors != null) {
                ApacheHttpResponseWrapper httpResponseWrapper = new ApacheHttpResponseWrapper(httpResponse);
                for (HttpWebServiceProcessor each : this.httpWebServiceProcessors) {
                    each.afterExecute(this, httpResponseWrapper);
                }
            }
            this.inputStream = httpResponse.getEntity() != null ? httpResponse.getEntity().getContent() : null;
            Header contentEncoding = httpResponse.getFirstHeader("Content-Encoding");
            if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                this.inputStream = new GZIPInputStream(this.inputStream);
            }
            Object object = parser != null && this.inputStream != null ? parser.parse(this.inputStream) : null;
            return (T)object;
        }
        catch (ClientProtocolException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof CircularRedirectException) {
                throw new ConnectionException(e, false);
            }
            throw new UnexpectedException(e);
        }
        catch (ConnectTimeoutException e) {
            throw new ConnectionException(e, true);
        }
        catch (IOException e) {
            throw new ConnectionException(e, false);
        }
        finally {
            FileUtils.safeClose(this.inputStream);
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
    }

    @Override
    public String getUrl() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ssl != false && this.server.supportsSsl() != false ? "https" : "http");
        builder.append("://");
        builder.append(this.server.getBaseUrl());
        builder.append(this.getUrlSuffix());
        return builder.toString();
    }

    @Override
    public String getUrlSuffix() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getUrlSegments());
        builder.append(this.makeStringParameters());
        return builder.toString();
    }

    protected String makeStringParameters() {
        StringBuilder params = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.getQueryParameters().entrySet()) {
            if (isFirst) {
                params.append("?");
                isFirst = false;
            } else {
                params.append("&");
            }
            params.append(entry.getKey());
            params.append("=");
            params.append(entry.getValue());
        }
        return params.toString();
    }

    protected String getUrlSegments() {
        return this.urlSegments.isEmpty() ? "" : "/" + StringUtils.join(this.urlSegments, "/");
    }

    @Override
    public void addUrlSegment(Object segment) {
        String segmentString = segment.toString();
        if (StringUtils.isNotEmpty(segmentString).booleanValue()) {
            this.urlSegments.add(EncodingUtils.encodeURL(segmentString));
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        }
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public void addQueryParameter(String name, Object value) {
        if (value != null) {
            this.queryParameters.put(name, EncodingUtils.encodeURL(value.toString()));
        }
    }

    @Override
    public void addQueryParameter(String name, Collection<?> values) {
        this.addQueryParameter(name, StringUtils.join(values));
    }

    protected void addHeaders(HttpUriRequest httpUriRequest) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpUriRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }

    protected void addCookies(HttpClient client) {
        if (client instanceof DefaultHttpClient) {
            for (Cookie cookie : this.cookies) {
                ((DefaultHttpClient)DefaultHttpClient.class.cast(client)).getCookieStore().addCookie(cookie);
            }
        }
    }

    @Override
    public void addHttpWebServiceProcessor(HttpWebServiceProcessor httpWebServiceProcessor) {
        this.httpWebServiceProcessors.add(httpWebServiceProcessor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.server.getBaseUrl();
    }

    protected Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected abstract HttpUriRequest createHttpUriRequest(String var1);

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }
}

