/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.apache;

import com.jdroid.java.http.apache.HttpClientFactory;
import com.jdroid.java.utils.StringUtils;
import org.apache.http.impl.client.DefaultHttpClient;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int DEFAULT_SO_TIMEOUT = 60000;
    private static HttpClientFactory INSTANCE;

    public static HttpClientFactory get() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultHttpClientFactory();
        }
        return INSTANCE;
    }

    @Override
    public DefaultHttpClient createHttpClient() {
        return this.createHttpClient(null, null);
    }

    @Override
    public DefaultHttpClient createHttpClient(Integer timeout, String userAgent) {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.connection.timeout", (Object)(timeout != null ? timeout : 10000));
        client.getParams().setParameter("http.socket.timeout", (Object)60000);
        if (StringUtils.isNotBlank(userAgent)) {
            client.getParams().setParameter("http.useragent", (Object)userAgent);
        }
        return client;
    }
}

