/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.apache.put;

import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.HttpWebServiceProcessor;
import com.jdroid.java.http.MultipartWebService;
import com.jdroid.java.http.Server;
import com.jdroid.java.http.apache.HttpClientFactory;
import com.jdroid.java.http.apache.post.ByteArrayInputStreamBody;
import com.jdroid.java.http.apache.put.ApacheHttpPutWebService;
import com.jdroid.java.marshaller.MarshallerMode;
import com.jdroid.java.marshaller.MarshallerProvider;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class ApacheMultipartHttpPutWebService
extends ApacheHttpPutWebService
implements MultipartWebService {
    private MultipartEntity multipartEntity = new MultipartEntity();

    public ApacheMultipartHttpPutWebService(HttpClientFactory httpClientFactory, Server server, List<Object> urlSegments, List<HttpWebServiceProcessor> httpWebServiceProcessors) {
        super(httpClientFactory, server, urlSegments, httpWebServiceProcessors);
    }

    @Override
    protected void addEntity(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase) {
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)this.multipartEntity);
    }

    @Override
    public void addHeader(String name, String value) {
        if (!name.equals("content-type")) {
            super.addHeader(name, value);
        }
    }

    @Override
    public void addPart(String name, ByteArrayInputStream in, String mimeType, String filename) {
        this.multipartEntity.addPart(name, (ContentBody)new ByteArrayInputStreamBody(in, mimeType, filename));
    }

    @Override
    public void addPart(String name, Object value, String mimeType) {
        if (value != null) {
            try {
                this.multipartEntity.addPart(name, (ContentBody)new StringBody(value.toString(), mimeType, Charset.defaultCharset()));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    @Override
    public void addJsonPart(String name, Object value) {
        this.addPart(name, MarshallerProvider.get().marshall(value, MarshallerMode.COMPLETE, null), "application/json");
    }
}

