/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.cache;

import com.jdroid.java.http.HttpWebServiceProcessor;
import com.jdroid.java.http.WebService;
import com.jdroid.java.http.cache.Cache;
import com.jdroid.java.http.cache.CacheParser;
import com.jdroid.java.http.cache.CachingStrategy;
import com.jdroid.java.http.post.EntityEnclosingWebService;
import com.jdroid.java.parser.Parser;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.Hasher;
import com.jdroid.java.utils.LoggerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.slf4j.Logger;

public abstract class CachedWebService
implements EntityEnclosingWebService {
    private static final Logger LOGGER = LoggerUtils.getLogger(CachedWebService.class);
    private WebService webService;
    private CachingStrategy cachingStrategy;
    private Long timeToLive;
    private Cache cache;

    public CachedWebService(WebService webService, Cache cache) {
        this(webService, cache, null, null);
    }

    public CachedWebService(WebService webService, Cache cache, CachingStrategy cachingStrategy) {
        this(webService, cache, cachingStrategy, null);
    }

    public CachedWebService(WebService webService, Cache cache, CachingStrategy cachingStrategy, Long timeToLive) {
        this.webService = webService;
        this.cache = cache;
        this.cachingStrategy = cachingStrategy != null ? cachingStrategy : CachingStrategy.NO_CACHE;
        this.timeToLive = timeToLive;
    }

    @Override
    public <T> T execute(Parser parser) {
        LOGGER.debug("Executing cache strategy: " + (Object)((Object)this.cachingStrategy) + " for url: " + this.getUrl());
        return this.cachingStrategy.execute(this, parser);
    }

    protected abstract File getHttpCacheDirectory(Cache var1);

    @Override
    public <T> T execute() {
        return this.webService.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T readFromCache(Parser parser) {
        Object response;
        block7: {
            File cacheFile;
            block6: {
                response = null;
                cacheFile = new File(this.getHttpCacheDirectory(this.cache), this.generateCacheFileName());
                if (!cacheFile.exists() || cacheFile.length() <= 0L) break block6;
                long diff = System.currentTimeMillis() - cacheFile.lastModified();
                if (this.timeToLive != null && (diff < 0L || diff >= this.timeToLive)) break block7;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(cacheFile);
                    response = parser.parse(fileInputStream);
                    LOGGER.info("Reading http request from cache: " + cacheFile.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn("Error when opening cache file: " + cacheFile.getAbsolutePath(), (Throwable)e);
                    FileUtils.safeClose(fileInputStream);
                }
                catch (Exception e2) {
                    LoggerUtils.logHandledException(LOGGER, e2);
                    {
                        catch (Throwable throwable) {
                            FileUtils.safeClose(fileInputStream);
                            throw throwable;
                        }
                    }
                    FileUtils.safeClose(fileInputStream);
                }
                FileUtils.safeClose(fileInputStream);
                break block7;
                break block7;
            }
            LOGGER.info("Http request not present on cache: " + cacheFile.getAbsolutePath());
        }
        return (T)response;
    }

    public <T> T executeRequest(Parser parser) {
        String cacheFileName = this.generateCacheFileName();
        File cacheFile = new File(this.getHttpCacheDirectory(this.cache), cacheFileName);
        return this.webService.execute(new CacheParser(parser, cacheFile));
    }

    protected String generateCacheFileName() {
        return CachedWebService.generateCacheFileName(this.getUrlSuffix());
    }

    public static String generateCacheFileName(String key) {
        return Hasher.SHA_1.hash(key) + ".cache";
    }

    @Override
    public void addHeader(String name, String value) {
        this.webService.addHeader(name, value);
    }

    @Override
    public void addQueryParameter(String name, Object value) {
        this.webService.addQueryParameter(name, value);
    }

    @Override
    public void addQueryParameter(String name, Collection<?> values) {
        this.webService.addQueryParameter(name, values);
    }

    @Override
    public void addUrlSegment(Object segment) {
        this.webService.addUrlSegment(segment);
    }

    @Override
    public void addHttpWebServiceProcessor(HttpWebServiceProcessor httpWebServiceProcessor) {
        this.webService.addHttpWebServiceProcessor(httpWebServiceProcessor);
    }

    @Override
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.webService.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.webService.setUserAgent(userAgent);
    }

    @Override
    public void setSsl(Boolean ssl) {
        this.webService.setSsl(ssl);
    }

    @Override
    public String getUrl() {
        return this.webService.getUrl();
    }

    @Override
    public String getUrlSuffix() {
        return this.webService.getUrlSuffix();
    }

    @Override
    public void setEntity(String content) {
        ((EntityEnclosingWebService)this.webService).setEntity(content);
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }
}

