/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.cache;

import com.jdroid.java.concurrent.ExecutorUtils;
import com.jdroid.java.http.cache.CachedWebService;
import com.jdroid.java.parser.Parser;
import com.jdroid.java.utils.LoggerUtils;
import org.slf4j.Logger;

public enum CachingStrategy {
    NO_CACHE{

        @Override
        public <T> T execute(CachedWebService cachedWebService, Parser parser) {
            return cachedWebService.executeRequest(parser);
        }
    }
    ,
    CACHE_FIRST{

        @Override
        public <T> T execute(CachedWebService cachedWebService, Parser parser) {
            Object response = cachedWebService.readFromCache(parser);
            if (response == null) {
                response = cachedWebService.executeRequest(parser);
            }
            return response;
        }
    }
    ,
    CACHE_FIRST_ASYNCH_REMOTE{

        @Override
        public <T> T execute(final CachedWebService cachedWebService, final Parser parser) {
            Object response = cachedWebService.readFromCache(parser);
            if (response == null) {
                response = cachedWebService.executeRequest(parser);
            } else {
                ExecutorUtils.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cachedWebService.executeRequest(parser);
                        }
                        catch (Exception e) {
                            LoggerUtils.logHandledException(LOGGER, e);
                        }
                    }
                });
            }
            return response;
        }
    }
    ,
    CACHE_FORCED_FIRST_ASYNCH_REMOTE{

        @Override
        public <T> T execute(final CachedWebService cachedWebService, final Parser parser) {
            Long originalTimeToLive = cachedWebService.getTimeToLive();
            cachedWebService.setTimeToLive(null);
            Object response = cachedWebService.readFromCache(parser);
            if (response == null) {
                response = cachedWebService.executeRequest(parser);
            } else {
                cachedWebService.setTimeToLive(originalTimeToLive);
                ExecutorUtils.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CACHE_FIRST.execute(cachedWebService, parser);
                        }
                        catch (Exception e) {
                            LoggerUtils.logHandledException(LOGGER, e);
                        }
                    }
                });
            }
            return response;
        }
    }
    ,
    CACHE_ONLY{

        @Override
        public <T> T execute(CachedWebService cachedWebService, Parser parser) {
            return cachedWebService.readFromCache(parser);
        }
    }
    ,
    REMOTE_FIRST{

        @Override
        public <T> T execute(CachedWebService cachedWebService, Parser parser) {
            T response = null;
            try {
                response = cachedWebService.executeRequest(parser);
            }
            catch (Exception e) {
                LoggerUtils.logHandledException(LOGGER, e);
            }
            if (response == null) {
                response = cachedWebService.readFromCache(parser);
            }
            return response;
        }
    };

    private static final Logger LOGGER;

    public abstract <T> T execute(CachedWebService var1, Parser var2);

    static {
        LOGGER = LoggerUtils.getLogger(CachingStrategy.class);
    }
}

