/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.parser.json;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.json.JSONArray;
import com.jdroid.java.json.JSONObject;
import com.jdroid.java.parser.Parser;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.LoggerUtils;
import com.jdroid.java.utils.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public abstract class JsonParser<T>
implements Parser {
    private static final Logger LOGGER = LoggerUtils.getLogger(JsonParser.class);
    private static final String ARRAY_PREFIX = "[";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(String input) {
        LOGGER.trace("Parsing started.");
        try {
            LOGGER.trace(input);
            Object json = input.startsWith(ARRAY_PREFIX) ? new JSONArray(input) : new JSONObject(input);
            Object object = this.parse(json);
            return object;
        }
        finally {
            LOGGER.trace("Parsing finished.");
        }
    }

    @Override
    public Object parse(InputStream inputStream) {
        String content = FileUtils.toString(inputStream);
        return StringUtils.isNotBlank(content) ? this.parse(content) : null;
    }

    public abstract Object parse(T var1);

    protected <ITEM> List<ITEM> parseList(JSONObject jsonObject, String jsonKey, JsonParser<JSONObject> parser) {
        return this.parseList(jsonObject.getJSONArray(jsonKey), parser);
    }

    protected <ITEM> List<ITEM> parseList(JSONArray jsonArray, JsonParser<JSONObject> parser) {
        ArrayList<Object> list = Lists.newArrayList();
        if (jsonArray != null) {
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                Object parse = parser.parse(jsonArray.getJSONObject(i));
                if (parse == null) continue;
                list.add(parse);
            }
        }
        return list;
    }
}

