/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.repository;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.domain.Identifiable;
import com.jdroid.java.repository.Repository;
import com.jdroid.java.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class InMemoryRepository<T extends Identifiable>
implements Repository<T> {
    private long nextId = 1L;
    private Map<Long, T> items = Maps.newLinkedHashMap();

    @Override
    public void add(T item) {
        if (item.getId() == null) {
            ReflectionUtils.setId(item, this.nextId++);
        }
        this.items.put(item.getId(), item);
    }

    @Override
    public void addAll(Collection<T> items) {
        for (Identifiable item : items) {
            this.add(item);
        }
    }

    @Override
    public void update(T item) {
        this.add(item);
    }

    @Override
    public void remove(T item) {
        this.items.remove(item.getId());
    }

    @Override
    public void removeAll(Collection<T> items) {
        for (Identifiable item : items) {
            this.remove(item);
        }
    }

    @Override
    public void replaceAll(Collection<T> items) {
        this.removeAll();
        this.addAll(items);
    }

    @Override
    public List<T> getAll() {
        return Lists.newArrayList(this.items.values());
    }

    @Override
    public T get(Long id) {
        return (T)((Identifiable)this.items.get(id));
    }

    @Override
    public void removeAll() {
        this.items.clear();
    }

    @Override
    public void remove(Long id) {
        this.items.remove(id);
    }

    @Override
    public Boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Long getSize() {
        return this.items.size();
    }

    @Override
    public List<T> findByField(String fieldName, Object ... values) {
        return null;
    }

    @Override
    public List<T> getAll(List<Long> ids) {
        ArrayList<Identifiable> itemsList = Lists.newArrayList();
        for (Long each : ids) {
            Identifiable item = (Identifiable)this.items.get(each);
            if (item == null) continue;
            itemsList.add(item);
        }
        return itemsList;
    }

    @Override
    public T getUniqueInstance() {
        return (T)(this.items.isEmpty() ? null : (Identifiable)this.items.values().iterator().next());
    }
}

