/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.NumberUtils;
import com.jdroid.java.utils.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class DateUtils {
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int WEEK = 604800;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final String YYYYMMDDTHHMMSSZ_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZZZ";
    public static final String YYYYMMDDHHMMSSZ_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    public static final String YYYYMMDDHHMMSS_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSSSSS_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String MMDDYYYYHHMM_DATE_FORMAT = "MM/dd/yyyy HH:mm";
    public static final String MMDDYYYY_DATE_FORMAT = "MM/dd/yyyy";
    public static final String MMDDYYYY_SLASH_DATE_FORMAT = "MM-dd-yyyy";
    public static final String YYYYMMDD_DATE_FORMAT = "yyyy-MM-dd";
    public static final String EHHMMAA_DATE_FORMAT = "E hh:mm aa";
    public static final String E_DATE_FORMAT = "E";
    public static final String EEEE_DATE_FORMAT = "EEEE";
    public static final String MMMDHHMMAA_DATE_FORMAT = "MMM d hh:mm aa";
    public static final String MMMDYYYYHHMMAA_DATE_FORMAT = "MMM d yyyy hh:mm aa";
    public static final String MMMDYYYY_DATE_FORMAT = "MMM d yyyy";
    public static final String EEEE_MMMDYYYY_DATE_FORMAT = "EEEE MMM d yyyy";
    public static final String MMMD_DATE_FORMAT = "MMM d";
    public static final String EEEE_MMMD_DATE_FORMAT = "EEEE MMM d";
    public static final String MMMMD_DATE_FORMAT = "MMMM d";
    public static final String HHMMAA_DATE_FORMAT = "hh:mm aa";
    public static final String HHMM_DATE_FORMAT = "HH:mm";
    public static final String HHMMSS_DATE_FORMAT = "HH:mm:ss";
    public static final String EEEEDMMMM_DATE_FORMAT = "EEEE d MMMM";
    public static final String EEEEMMMM_DATE_FORMAT = "EEEE MMMM";
    public static final String EEMMMDYYYY_DATE_FORMAT = "EE, MMM d, yyyy";

    public static void init() {
    }

    public static Date parse(String dateFormatted, String dateFormat) {
        return DateUtils.parse(dateFormatted, new SimpleDateFormat(dateFormat));
    }

    public static Date parse(String dateFormatted, SimpleDateFormat dateFormat) {
        Date date = null;
        if (StringUtils.isNotEmpty(dateFormatted).booleanValue()) {
            try {
                date = dateFormat.parse(dateFormatted);
            }
            catch (ParseException e) {
                throw new UnexpectedException("Error parsing the date: '" + dateFormatted + "' with pattern: " + dateFormat.toPattern(), (Throwable)e);
            }
        }
        return date;
    }

    public static String formatToCardinal(Date date) {
        int day = DateUtils.getDayOfMonth(date);
        String ordinalSuffix = NumberUtils.getOrdinalSuffix(day);
        StringBuilder builder = new StringBuilder();
        builder.append(DateUtils.format(date, EEEEMMMM_DATE_FORMAT));
        builder.append(" ");
        builder.append(day);
        builder.append(ordinalSuffix);
        return builder.toString();
    }

    public static String format(Date date, String dateFormat) {
        return DateUtils.format(date, new SimpleDateFormat(dateFormat));
    }

    public static String format(Date date, DateFormat dateFormat) {
        return date != null ? dateFormat.format(date) : null;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.format(date, DateFormat.getDateTimeInstance());
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, DateFormat.getDateInstance());
    }

    public static String formatTime(Date date) {
        return DateUtils.format(date, DateFormat.getTimeInstance(3));
    }

    public static Date getDate(int year, int monthOfYear, int dayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, monthOfYear, dayOfMonth);
        DateUtils.truncate(calendar);
        return calendar.getTime();
    }

    public static Date getDate(Date date, Date time, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (time != null) {
            calendar.set(11, DateUtils.getHour(time, is24Hour));
            calendar.set(12, DateUtils.getMinute(time));
            calendar.set(13, 0);
        } else {
            DateUtils.truncate(calendar);
        }
        return calendar.getTime();
    }

    public static Date getDate(Date date, Date time) {
        return DateUtils.getDate(date, time, true);
    }

    public static Date getDate(long milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        return calendar.getTime();
    }

    public static Date getTime(int hour, int minutes) {
        return DateUtils.getTime(hour, minutes, true);
    }

    public static Date getTime(int hour, int minutes, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(is24Hour != false ? 11 : 10, hour);
        calendar.set(12, minutes);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static int getYear() {
        return DateUtils.getYear(DateUtils.now());
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int getHour(Date date, Boolean is24Hour) {
        return DateUtils.getHour(date, TimeZone.getDefault(), is24Hour);
    }

    public static int getHour(Date date, TimeZone timeZone, Boolean is24Hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(timeZone);
        return calendar.get(is24Hour != false ? 11 : 10);
    }

    public static int getMinute(Date date) {
        return DateUtils.getMinute(date, TimeZone.getDefault());
    }

    public static int getMinute(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(timeZone);
        return calendar.get(12);
    }

    public static DayOfWeek getWeekDay() {
        return DateUtils.getWeekDay(DateUtils.now());
    }

    public static DayOfWeek getWeekDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return DayOfWeek.findByNumber(dayOfWeek);
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addMonths(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, days);
        return calendar.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date truncate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.truncate(calendar);
        return calendar.getTime();
    }

    public static void truncate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date now() {
        return new Date();
    }

    public static boolean isBetween(Date date, Date startDate, Date endDate) {
        return DateUtils.isBeforeEquals(startDate, date) && DateUtils.isAfterEquals(endDate, date);
    }

    public static boolean isBefore(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) < 0;
    }

    public static boolean isBeforeEquals(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) <= 0;
    }

    public static boolean isAfterEquals(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) >= 0;
    }

    public static boolean isAfter(Date date, Date dateToCompare) {
        return date.compareTo(dateToCompare) > 0;
    }

    public static boolean periodsOverlap(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return !(!startDate1.before(endDate2) && !startDate1.equals(endDate2) || !endDate1.after(startDate2) && !endDate1.equals(startDate2));
    }

    public static boolean containsPeriod(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return DateUtils.isBeforeEquals(startDate1, startDate2) && DateUtils.isAfterEquals(endDate1, endDate2);
    }

    private static Calendar todayCalendar() {
        Calendar calendar = Calendar.getInstance();
        DateUtils.truncate(calendar);
        return calendar;
    }

    public static Date tomorrow() {
        Calendar calendar = DateUtils.todayCalendar();
        return DateUtils.addDays(calendar.getTime(), 1);
    }

    public static Date today() {
        Calendar calendar = DateUtils.todayCalendar();
        return calendar.getTime();
    }

    public static Date yesterday() {
        Calendar calendar = DateUtils.todayCalendar();
        return DateUtils.addDays(calendar.getTime(), -1);
    }

    public static Date monthsAway(int months) {
        return DateUtils.addMonths(DateUtils.todayCalendar().getTime(), months);
    }

    public static Date oneMonthInFuture() {
        return DateUtils.monthsAway(1);
    }

    public static Date oneMonthInPast() {
        return DateUtils.monthsAway(-1);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        DateUtils.truncate(calendar);
        return calendar.getTime();
    }

    public static String formatDuration(long duration) {
        long hours = TimeUnit.MILLISECONDS.toHours(duration);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - hours * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - hours * 60L * 60L - minutes * 60L;
        long milliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - hours * 60L * 60L * 1000L - minutes * 60L * 1000L - seconds * 1000L;
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours);
            builder.append("h, ");
        }
        if (minutes > 0L || builder.length() > 0) {
            builder.append(minutes);
            builder.append("m, ");
        }
        if (seconds > 0L || builder.length() > 0) {
            builder.append(seconds);
            builder.append("s, ");
        }
        if (milliseconds >= 0L) {
            builder.append(milliseconds);
            builder.append("ms");
        }
        return builder.toString();
    }

    public static enum DayOfWeek {
        SUNDAY("Sunday", 1, true),
        MONDAY("Monday", 2, false),
        TUESDAY("Tuesday", 3, false),
        WEDNESDAY("Wednesday", 4, false),
        THURSDAY("Thursday", 5, false),
        FRIDAY("Friday", 6, false),
        SATURDAY("Saturday", 7, true);

        private String name;
        private int number;
        private Boolean weekend;

        private DayOfWeek(String name, int number, Boolean weekend) {
            this.name = name;
            this.number = number;
            this.weekend = weekend;
        }

        public Boolean isWeekend() {
            return this.weekend;
        }

        public static DayOfWeek findByNumber(int number) {
            for (DayOfWeek each : DayOfWeek.values()) {
                if (each.getNumber() != number) continue;
                return each;
            }
            return null;
        }

        public DayOfWeek getNextDay() {
            return DayOfWeek.findByNumber(this.number % 7 + 1);
        }

        public static List<DayOfWeek> getWeekDays() {
            ArrayList<DayOfWeek> weekDays = Lists.newArrayList();
            for (DayOfWeek each : DayOfWeek.values()) {
                if (each.isWeekend().booleanValue()) continue;
                weekDays.add(each);
            }
            return weekDays;
        }

        public String toString() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

