/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.logger.MuteLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static boolean enabled = false;
    private static ExceptionLogger exceptionLogger;
    private static final Logger MUTE_LOGGER;

    public static Logger getLogger(Object name) {
        return LoggerUtils.getLogger(name.getClass());
    }

    public static Logger getLogger(Class<?> clazz) {
        if (enabled) {
            return LoggerFactory.getLogger((String)LoggerUtils.getLimitedName(clazz.getSimpleName()));
        }
        return MUTE_LOGGER;
    }

    private static String getLimitedName(String name) {
        return name.substring(0, Math.min(name.length(), 23));
    }

    public static void setEnabled(boolean enabled) {
        LoggerUtils.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void logHandledException(Logger logger, Exception e) {
        if (exceptionLogger != null) {
            exceptionLogger.logHandledException(e);
        } else {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void setExceptionLogger(ExceptionLogger exceptionLogger) {
        LoggerUtils.exceptionLogger = exceptionLogger;
    }

    static {
        MUTE_LOGGER = new MuteLogger();
    }

    public static interface ExceptionLogger {
        public void logHandledException(Throwable var1);
    }
}

