/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9\\+-]+(\\.[_A-Za-z0-9\\+-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z]{2,}){1}$)");

    public static boolean isValidEmail(String value) {
        return ValidationUtils.match(value, EMAIL_PATTERN);
    }

    private static boolean match(String value, Pattern pattern) {
        return StringUtils.isNotEmpty(value) != false && pattern.matcher(value).matches();
    }

    public static boolean isValidURL(String value) {
        try {
            new URL(value);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static boolean isValidURLWithoutProtocol(String value) {
        return ValidationUtils.isValidURL("http://" + value);
    }

    public static boolean isValidDouble(String number) {
        try {
            Double.parseDouble(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

