/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.HttpMethod;
import com.jdroid.java.http.HttpResponseWrapper;
import com.jdroid.java.http.HttpService;
import com.jdroid.java.http.HttpServiceProcessor;
import com.jdroid.java.http.Server;
import com.jdroid.java.http.parser.Parser;
import com.jdroid.java.utils.EncodingUtils;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.LoggerUtils;
import com.jdroid.java.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractHttpService
implements HttpService {
    protected static final Logger LOGGER = LoggerUtils.getLogger(AbstractHttpService.class);
    private Boolean ssl = false;
    private Integer connectionTimeout = 10000;
    private Integer readTimeout = 60000;
    private String userAgent;
    private Server server;
    private List<Object> urlSegments;
    private Map<String, String> queryParameters = Maps.newLinkedHashMap();
    private Map<String, String> headers = Maps.newHashMap();
    private List<HttpServiceProcessor> httpServiceProcessors = Lists.newArrayList();
    private HttpResponseWrapper httpResponseWrapper;

    public AbstractHttpService(Server server, List<Object> urlSegments, List<HttpServiceProcessor> httpServiceProcessors) {
        this.urlSegments = Lists.newArrayList();
        if (urlSegments != null) {
            for (Object segment : urlSegments) {
                this.addUrlSegment(segment);
            }
        }
        this.server = server;
        if (httpServiceProcessors != null) {
            for (HttpServiceProcessor each : httpServiceProcessors) {
                this.addHttpServiceProcessor(each);
            }
        }
    }

    @Override
    public final void execute() {
        this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public <T> T execute(Parser parser) {
        block7: {
            inputStream = null;
            try {
                for (HttpServiceProcessor each : this.httpServiceProcessors) {
                    each.beforeExecute(this);
                }
                url = this.getUrl();
                AbstractHttpService.LOGGER.debug((Object)this.getHttpMethod() + ": " + url);
                if (!this.queryParameters.isEmpty()) {
                    AbstractHttpService.LOGGER.debug("Query Parameters: " + this.queryParameters.toString());
                }
                if (!this.headers.isEmpty()) {
                    AbstractHttpService.LOGGER.debug("Headers: " + this.headers.toString());
                }
                this.httpResponseWrapper = this.doExecute(url);
                for (HttpServiceProcessor each : this.httpServiceProcessors) {
                    each.afterExecute(this, this.httpResponseWrapper);
                }
                if (parser == null) ** GOTO lbl30
                inputStream = this.httpResponseWrapper.getInputStream();
                if (inputStream == null) break block7;
                var4_4 = parser.parse(inputStream);
            }
            catch (Throwable var6_6) {
                FileUtils.safeClose(inputStream);
                this.doFinally();
                throw var6_6;
            }
            FileUtils.safeClose(inputStream);
            this.doFinally();
            return (T)var4_4;
        }
        throw new UnexpectedException("The web service was expecting a response, but it was null");
lbl30:
        // 1 sources

        var4_4 = null;
        FileUtils.safeClose(inputStream);
        this.doFinally();
        return (T)var4_4;
    }

    protected void doFinally() {
    }

    public abstract HttpMethod getHttpMethod();

    protected abstract HttpResponseWrapper doExecute(String var1);

    @Override
    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    public Boolean isSsl() {
        return this.ssl;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getUrl() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isSsl() != false && this.getServer().supportsSsl() != false ? "https" : "http");
        builder.append("://");
        builder.append(this.getServer().getBaseUrl());
        builder.append(this.getUrlSuffix());
        return builder.toString();
    }

    @Override
    public String getUrlSuffix() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getUrlSegments());
        builder.append(this.makeStringParameters());
        return builder.toString();
    }

    protected String makeStringParameters() {
        StringBuilder params = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.getQueryParameters().entrySet()) {
            if (isFirst) {
                params.append("?");
                isFirst = false;
            } else {
                params.append("&");
            }
            params.append(entry.getKey());
            params.append("=");
            params.append(entry.getValue());
        }
        return params.toString();
    }

    @Override
    public void addQueryParameter(String name, Collection<?> values) {
        this.addQueryParameter(name, StringUtils.join(values));
    }

    @Override
    public void addQueryParameter(String name, Object value) {
        if (value != null) {
            this.queryParameters.put(name, EncodingUtils.encodeURL(value.toString()));
        }
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public void addUrlSegment(Object segment) {
        String segmentString = segment.toString();
        if (StringUtils.isNotEmpty(segmentString).booleanValue()) {
            this.urlSegments.add(EncodingUtils.encodeURL(segmentString));
        }
    }

    public String getUrlSegments() {
        return this.urlSegments.isEmpty() ? "" : "/" + StringUtils.join(this.urlSegments, "/");
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeaderValue(String key) {
        return this.headers.get(key);
    }

    @Override
    public void addHeader(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.server.getBaseUrl();
    }

    @Override
    public void addHttpServiceProcessor(HttpServiceProcessor httpServiceProcessor) {
        this.httpServiceProcessors.add(httpServiceProcessor);
        httpServiceProcessor.onInit(this);
    }

    @Override
    public HttpResponseWrapper getHttpResponseWrapper() {
        return this.httpResponseWrapper;
    }
}

