/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.cache;

import com.jdroid.java.http.HttpResponseWrapper;
import com.jdroid.java.http.HttpService;
import com.jdroid.java.http.HttpServiceProcessor;
import com.jdroid.java.http.cache.Cache;
import com.jdroid.java.http.cache.CacheParser;
import com.jdroid.java.http.cache.CachingStrategy;
import com.jdroid.java.http.parser.Parser;
import com.jdroid.java.http.post.BodyEnclosingHttpService;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.Hasher;
import com.jdroid.java.utils.LoggerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.slf4j.Logger;

public abstract class CachedHttpService
implements BodyEnclosingHttpService {
    private static final Logger LOGGER = LoggerUtils.getLogger(CachedHttpService.class);
    private HttpService httpService;
    private CachingStrategy cachingStrategy;
    private Long timeToLive;
    private Cache cache;

    public CachedHttpService(HttpService httpService, Cache cache) {
        this(httpService, cache, null, null);
    }

    public CachedHttpService(HttpService httpService, Cache cache, CachingStrategy cachingStrategy) {
        this(httpService, cache, cachingStrategy, null);
    }

    public CachedHttpService(HttpService httpService, Cache cache, CachingStrategy cachingStrategy, Long timeToLive) {
        this.httpService = httpService;
        this.cache = cache;
        this.cachingStrategy = cachingStrategy != null ? cachingStrategy : CachingStrategy.NO_CACHE;
        this.timeToLive = timeToLive;
    }

    @Override
    public <T> T execute(Parser parser) {
        LOGGER.debug("Executing cache strategy: " + (Object)((Object)this.cachingStrategy) + " for url: " + this.getUrl());
        return this.cachingStrategy.execute(this, parser);
    }

    protected abstract File getHttpCacheDirectory(Cache var1);

    @Override
    public void execute() {
        this.httpService.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T readFromCache(Parser parser) {
        Object response;
        block7: {
            File cacheFile;
            block6: {
                response = null;
                cacheFile = new File(this.getHttpCacheDirectory(this.cache), this.generateCacheFileName());
                if (!cacheFile.exists() || cacheFile.length() <= 0L) break block6;
                long diff = System.currentTimeMillis() - cacheFile.lastModified();
                if (this.timeToLive != null && (diff < 0L || diff >= this.timeToLive)) break block7;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(cacheFile);
                    response = parser.parse(fileInputStream);
                    LOGGER.info("Reading http request from cache: " + cacheFile.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn("Error when opening cache file: " + cacheFile.getAbsolutePath(), (Throwable)e);
                    FileUtils.safeClose(fileInputStream);
                }
                catch (Exception e2) {
                    LoggerUtils.logHandledException(LOGGER, e2);
                    {
                        catch (Throwable throwable) {
                            FileUtils.safeClose(fileInputStream);
                            throw throwable;
                        }
                    }
                    FileUtils.safeClose(fileInputStream);
                }
                FileUtils.safeClose(fileInputStream);
                break block7;
                break block7;
            }
            LOGGER.info("Http request not present on cache: " + cacheFile.getAbsolutePath());
        }
        return (T)response;
    }

    public <T> T executeRequest(Parser parser) {
        String cacheFileName = this.generateCacheFileName();
        File cacheFile = new File(this.getHttpCacheDirectory(this.cache), cacheFileName);
        return this.httpService.execute(new CacheParser(parser, cacheFile));
    }

    protected String generateCacheFileName() {
        return CachedHttpService.generateCacheFileName(this.getUrlSuffix());
    }

    public static String generateCacheFileName(String key) {
        return Hasher.SHA_1.hash(key) + ".cache";
    }

    @Override
    public void addHeader(String name, String value) {
        this.httpService.addHeader(name, value);
    }

    @Override
    public void addQueryParameter(String name, Object value) {
        this.httpService.addQueryParameter(name, value);
    }

    @Override
    public void addQueryParameter(String name, Collection<?> values) {
        this.httpService.addQueryParameter(name, values);
    }

    @Override
    public void addUrlSegment(Object segment) {
        this.httpService.addUrlSegment(segment);
    }

    @Override
    public void addHttpServiceProcessor(HttpServiceProcessor httpServiceProcessor) {
        this.httpService.addHttpServiceProcessor(httpServiceProcessor);
    }

    @Override
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.httpService.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.httpService.setUserAgent(userAgent);
    }

    @Override
    public void setSsl(Boolean ssl) {
        this.httpService.setSsl(ssl);
    }

    @Override
    public String getUrl() {
        return this.httpService.getUrl();
    }

    @Override
    public String getUrlSuffix() {
        return this.httpService.getUrlSuffix();
    }

    @Override
    public void setBody(String body) {
        ((BodyEnclosingHttpService)this.httpService).setBody(body);
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public String getHeaderValue(String key) {
        return this.httpService.getHeaderValue(key);
    }

    @Override
    public HttpResponseWrapper getHttpResponseWrapper() {
        return this.httpService.getHttpResponseWrapper();
    }
}

