/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Sets;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class PropertiesUtils {
    private static List<Properties> propertiesList = Lists.newArrayList();

    public static void loadExternalProperties(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(fileName));
            Properties properties = new Properties();
            properties.load(inputStream);
            propertiesList.add(properties);
        }
        catch (IOException e) {
            try {
                throw new UnexpectedException("Cannot read from file: " + fileName, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.safeClose(inputStream);
                throw throwable;
            }
        }
        FileUtils.safeClose(inputStream);
    }

    public static void loadProperties(String resourceName) {
        URL url = PropertiesUtils.class.getClassLoader().getResource(resourceName);
        if (url != null) {
            InputStream inputStream = null;
            try {
                Properties properties = new Properties();
                inputStream = url.openStream();
                properties.load(inputStream);
                propertiesList.add(properties);
            }
            catch (IOException e) {
                try {
                    throw new UnexpectedException("Cannot read from resource: " + resourceName, (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtils.safeClose(inputStream);
                    throw throwable;
                }
            }
            FileUtils.safeClose(inputStream);
        }
    }

    private static String getStringProperty(Properties properties, String name) {
        return properties != null ? properties.getProperty(name) : null;
    }

    public static String getStringProperty(String name) {
        String value = null;
        for (Properties properties : propertiesList) {
            value = PropertiesUtils.getStringProperty(properties, name);
            if (value == null) continue;
            return value;
        }
        return value;
    }

    public static String getStringProperty(String name, String defaultValue) {
        String value = PropertiesUtils.getStringProperty(name);
        return value != null ? value : defaultValue;
    }

    public static Integer getIntegerProperty(String name) {
        return PropertiesUtils.getIntegerProperty(name, null);
    }

    public static Integer getIntegerProperty(String name, Integer defaultValue) {
        String value = PropertiesUtils.getStringProperty(name);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public static Boolean getBooleanProperty(String name) {
        return PropertiesUtils.getBooleanProperty(name, null);
    }

    public static Boolean getBooleanProperty(String name, Boolean defaultValue) {
        String value = PropertiesUtils.getStringProperty(name);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    public static Set<String> getStringSetProperty(String name) {
        String value = PropertiesUtils.getStringProperty(name);
        return Sets.newHashSet(StringUtils.splitToCollectionWithCommaSeparator(value));
    }
}

