/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.analytics;

import com.jdroid.java.analytics.BaseAnalyticsTracker;
import com.jdroid.java.collections.Lists;
import com.jdroid.java.utils.LoggerUtils;
import java.util.List;
import org.slf4j.Logger;

public class BaseAnalyticsSender<T extends BaseAnalyticsTracker>
implements BaseAnalyticsTracker {
    private static final Logger LOGGER = LoggerUtils.getLogger(BaseAnalyticsSender.class);
    private List<T> trackers = Lists.newArrayList();

    @SafeVarargs
    public BaseAnalyticsSender(T ... trackers) {
        this((List<T>)Lists.newArrayList(trackers));
    }

    public BaseAnalyticsSender(List<T> trackers) {
        for (BaseAnalyticsTracker tracker : trackers) {
            if (!tracker.isEnabled().booleanValue()) continue;
            this.trackers.add(tracker);
        }
    }

    @Override
    public Boolean isEnabled() {
        return null;
    }

    protected List<T> getTrackers() {
        return this.trackers;
    }

    public void addTracker(T tracker) {
        this.trackers.add(tracker);
    }

    public abstract class TrackerRunnable
    implements Runnable {
        @Override
        public void run() {
            for (BaseAnalyticsTracker tracker : BaseAnalyticsSender.this.getTrackers()) {
                try {
                    if (!tracker.isEnabled().booleanValue()) continue;
                    this.track(tracker);
                }
                catch (Exception e) {
                    LoggerUtils.logHandledException(LOGGER, e);
                }
            }
        }

        protected abstract void track(T var1);
    }
}

