/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.api;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.HttpService;
import com.jdroid.java.http.HttpServiceFactory;
import com.jdroid.java.http.HttpServiceProcessor;
import com.jdroid.java.http.MultipartHttpService;
import com.jdroid.java.http.Server;
import com.jdroid.java.http.cache.Cache;
import com.jdroid.java.http.cache.CachedHttpService;
import com.jdroid.java.http.cache.CachingStrategy;
import com.jdroid.java.http.mock.AbstractMockHttpService;
import com.jdroid.java.http.post.BodyEnclosingHttpService;
import com.jdroid.java.marshaller.MarshallerMode;
import com.jdroid.java.marshaller.MarshallerProvider;
import com.jdroid.java.utils.ReflectionUtils;
import java.io.File;
import java.util.List;
import java.util.Map;

public abstract class AbstractApiService {
    private HttpServiceFactory httpServiceFactory = this.createHttpServiceFactory();

    protected HttpService newGetService(Object ... urlSegments) {
        return this.newGetService((Boolean)false, urlSegments);
    }

    protected HttpService newGetService(List<HttpServiceProcessor> processors, Object ... urlSegments) {
        return this.newGetService((Boolean)false, processors, urlSegments);
    }

    protected HttpService newGetService(Boolean mocked, Object ... urlSegments) {
        return this.newGetService(mocked, this.getHttpServiceProcessors(), urlSegments);
    }

    protected HttpService newGetService(Boolean mocked, List<HttpServiceProcessor> processors, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newGetService(this.getServer(), Lists.newArrayList(urlSegments), processors);
    }

    protected HttpService newCachedGetService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, List<HttpServiceProcessor> processors, Object ... urlSegments) {
        return this.newCachedGetService(this.httpServiceFactory.newGetService(this.getServer(), Lists.newArrayList(urlSegments), processors), cache, cachingStrategy, timeToLive);
    }

    protected HttpService newCachedGetService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, Object ... urlSegments) {
        return this.newCachedGetService(this.newGetService(urlSegments), cache, cachingStrategy, timeToLive);
    }

    private HttpService newCachedGetService(HttpService httpService, Cache cache, CachingStrategy cachingStrategy, Long timeToLive) {
        return this.newCachedhttpService(httpService, cache, cachingStrategy, timeToLive);
    }

    protected BodyEnclosingHttpService newPostService(Object ... urlSegments) {
        return this.newPostService((Boolean)false, urlSegments);
    }

    protected BodyEnclosingHttpService newPostService(Boolean mocked, Object ... urlSegments) {
        return this.newPostService(mocked, this.getHttpServiceProcessors(), urlSegments);
    }

    protected BodyEnclosingHttpService newPostService(Boolean mocked, List<HttpServiceProcessor> processors, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newPostService(this.getServer(), Lists.newArrayList(urlSegments), processors);
    }

    protected MultipartHttpService newMultipartPostService(Object ... urlSegments) {
        return this.newMultipartPostService(false, urlSegments);
    }

    protected MultipartHttpService newMultipartPostService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newMultipartPostService(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpServiceProcessors());
    }

    protected BodyEnclosingHttpService newFormPostService(Object ... urlSegments) {
        return this.newFormPostService(false, urlSegments);
    }

    protected BodyEnclosingHttpService newFormPostService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newFormPostService(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpServiceProcessors());
    }

    protected BodyEnclosingHttpService newPutService(Object ... urlSegments) {
        return this.newPutService((Boolean)false, urlSegments);
    }

    protected BodyEnclosingHttpService newPutService(Boolean mocked, Object ... urlSegments) {
        return this.newPutService(mocked, this.getHttpServiceProcessors(), urlSegments);
    }

    protected BodyEnclosingHttpService newPutService(Boolean mocked, List<HttpServiceProcessor> processors, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newPutService(this.getServer(), Lists.newArrayList(urlSegments), processors);
    }

    protected BodyEnclosingHttpService newCachedPutService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, Object ... urlSegments) {
        BodyEnclosingHttpService httpService = this.newPutService(urlSegments);
        return this.newCachedhttpService(httpService, cache, cachingStrategy, timeToLive);
    }

    protected MultipartHttpService newMultipartPutService(Object ... urlSegments) {
        return this.newMultipartPutService(false, urlSegments);
    }

    protected MultipartHttpService newMultipartPutService(Boolean mocked, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newMultipartPutService(this.getServer(), Lists.newArrayList(urlSegments), this.getHttpServiceProcessors());
    }

    protected HttpService newDeleteService(Object ... urlSegments) {
        return this.newDeleteService((Boolean)false, urlSegments);
    }

    protected HttpService newDeleteService(List<HttpServiceProcessor> processors, Object ... urlSegments) {
        return this.newDeleteService((Boolean)false, processors, urlSegments);
    }

    protected HttpService newDeleteService(Boolean mocked, Object ... urlSegments) {
        return this.newDeleteService(mocked, this.getHttpServiceProcessors(), urlSegments);
    }

    protected HttpService newDeleteService(Boolean mocked, List<HttpServiceProcessor> processors, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newDeleteService(this.getServer(), Lists.newArrayList(urlSegments), processors);
    }

    protected HttpService newCachedDeleteService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, Object ... urlSegments) {
        HttpService httpService = this.newDeleteService(urlSegments);
        return this.newCachedhttpService(httpService, cache, cachingStrategy, timeToLive);
    }

    protected BodyEnclosingHttpService newPatchService(Object ... urlSegments) {
        return this.newPatchService((Boolean)false, urlSegments);
    }

    protected BodyEnclosingHttpService newPatchService(Boolean mocked, Object ... urlSegments) {
        return this.newPatchService(mocked, this.getHttpServiceProcessors(), urlSegments);
    }

    protected BodyEnclosingHttpService newPatchService(Boolean mocked, List<HttpServiceProcessor> processors, Object ... urlSegments) {
        if (this.isHttpMockEnabled().booleanValue() || mocked.booleanValue()) {
            return this.getAbstractMockHttpServiceInstance(urlSegments);
        }
        return this.httpServiceFactory.newPatchService(this.getServer(), Lists.newArrayList(urlSegments), processors);
    }

    protected BodyEnclosingHttpService newCachedPatchService(Cache cache, CachingStrategy cachingStrategy, Long timeToLive, Object ... urlSegments) {
        BodyEnclosingHttpService httpService = this.newPatchService(urlSegments);
        return this.newCachedhttpService(httpService, cache, cachingStrategy, timeToLive);
    }

    protected CachedHttpService newCachedhttpService(HttpService httpService, Cache cache, CachingStrategy cachingStrategy, Long timeToLive) {
        return new CachedHttpService(httpService, cache, cachingStrategy, timeToLive){

            @Override
            protected File getHttpCacheDirectory(Cache cache) {
                return AbstractApiService.this.getHttpCacheDirectory(cache);
            }
        };
    }

    protected HttpServiceFactory createHttpServiceFactory() {
        HttpServiceFactory httpServiceFactory = this.createFactory("com.jdroid.java.http.okhttp.OkHttpServiceFactory");
        if (httpServiceFactory == null && (httpServiceFactory = this.createFactory("com.jdroid.java.http.apache.ApacheHttpServiceFactory")) == null) {
            httpServiceFactory = this.createFactory("com.jdroid.java.http.urlconnection.UrlConnectionHttpServiceFactory");
        }
        return httpServiceFactory;
    }

    private HttpServiceFactory createFactory(String className) {
        try {
            return (HttpServiceFactory)ReflectionUtils.newInstance(className);
        }
        catch (UnexpectedException e) {
            return null;
        }
    }

    protected abstract Server getServer();

    protected List<HttpServiceProcessor> getHttpServiceProcessors() {
        return this.getServer().getHttpServiceProcessors();
    }

    protected abstract AbstractMockHttpService getAbstractMockHttpServiceInstance(Object ... var1);

    protected abstract Boolean isHttpMockEnabled();

    protected File getHttpCacheDirectory(Cache cache) {
        return null;
    }

    protected void marshallSimple(BodyEnclosingHttpService httpService, Object object) {
        this.marshall(httpService, object, MarshallerMode.SIMPLE);
    }

    protected void marshall(BodyEnclosingHttpService httpService, Object object) {
        this.marshall(httpService, object, MarshallerMode.COMPLETE);
    }

    protected void marshall(BodyEnclosingHttpService httpService, Object object, MarshallerMode mode) {
        this.marshall(httpService, object, mode, null);
    }

    protected void marshall(BodyEnclosingHttpService httpService, Object object, Map<String, String> extras) {
        this.marshall(httpService, object, MarshallerMode.COMPLETE, extras);
    }

    protected void marshall(BodyEnclosingHttpService httpService, Object object, MarshallerMode mode, Map<String, String> extras) {
        httpService.setBody(MarshallerProvider.get().marshall(object, mode, extras).toString());
    }
}

