/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.collections;

import com.jdroid.java.collections.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Lists {
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> List<E> safeArrayList(List<E> list) {
        return list != null ? list : Lists.newArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new ArrayList<E>((Collection)elements) : Lists.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<E> list = Lists.newArrayList();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList<E> list = Lists.newLinkedList();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> trim(List<T> list, int maxCount) {
        if (list.size() > maxCount) {
            return Lists.newArrayList(list.subList(0, maxCount));
        }
        return list;
    }

    public static Boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static <T> List<T> filter(List<T> unfilteredList, Predicate<T> predicate) {
        ArrayList<T> filteredList = Lists.newArrayList();
        for (T each : unfilteredList) {
            if (!predicate.apply(each).booleanValue()) continue;
            filteredList.add(each);
        }
        return filteredList;
    }

    public static boolean intersect(Collection<?> a, Collection<?> b) {
        return !Collections.disjoint(a, b);
    }
}

