/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http;

import com.jdroid.java.exception.ConnectionException;
import com.jdroid.java.exception.HttpResponseException;
import com.jdroid.java.http.HttpResponseWrapper;
import com.jdroid.java.http.HttpService;
import com.jdroid.java.http.HttpServiceProcessor;

public class BasicHttpResponseValidator
implements HttpServiceProcessor {
    private static final BasicHttpResponseValidator INSTANCE = new BasicHttpResponseValidator();

    protected BasicHttpResponseValidator() {
    }

    public static BasicHttpResponseValidator get() {
        return INSTANCE;
    }

    @Override
    public void onInit(HttpService httpService) {
    }

    @Override
    public void beforeExecute(HttpService httpService) {
    }

    @Override
    public void afterExecute(HttpService httpService, HttpResponseWrapper httpResponse) {
        String message = httpResponse.logStatusCode();
        if (httpResponse.isSuccess().booleanValue()) {
            this.onSuccess(httpResponse, message);
        } else if (httpResponse.isClientError().booleanValue()) {
            this.onClientError(httpResponse, message);
        } else if (httpResponse.isServerError().booleanValue()) {
            this.onServerError(httpResponse, message);
        } else {
            throw new HttpResponseException(message);
        }
    }

    protected void onSuccess(HttpResponseWrapper httpResponse, String message) {
    }

    protected void onClientError(HttpResponseWrapper httpResponse, String message) {
        throw new HttpResponseException(message);
    }

    protected void onServerError(HttpResponseWrapper httpResponse, String message) {
        if (httpResponse.getStatusCode() == 504) {
            throw new ConnectionException(message);
        }
        throw new HttpResponseException(message);
    }
}

