/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.cache;

import com.jdroid.java.concurrent.ExecutorUtils;
import com.jdroid.java.http.parser.Parser;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.LoggerUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;

public class CacheParser
implements Parser {
    private static final Logger LOGGER = LoggerUtils.getLogger(CacheParser.class);
    private Parser parser;
    private File cacheFile;

    public CacheParser(Parser parser, File cacheFile) {
        this.parser = parser;
        this.cacheFile = cacheFile;
    }

    @Override
    public Object parse(InputStream inputStream) {
        final ByteArrayInputStream inputStreamCopy = FileUtils.copy(inputStream);
        Object object = this.parser.parse(inputStreamCopy);
        ExecutorUtils.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    inputStreamCopy.reset();
                }
                catch (IOException e) {
                    LoggerUtils.logHandledException(LOGGER, e);
                }
                FileUtils.copyStream(inputStreamCopy, CacheParser.this.cacheFile);
                LOGGER.debug("Saved http request to cache file: " + CacheParser.this.cacheFile.getAbsolutePath());
            }
        });
        return object;
    }

    @Override
    public Object parse(String input) {
        return null;
    }
}

