/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.cache;

import com.jdroid.java.concurrent.ExecutorUtils;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.cache.CachedHttpService;
import com.jdroid.java.http.parser.Parser;
import com.jdroid.java.utils.LoggerUtils;
import org.slf4j.Logger;

public enum CachingStrategy {
    NO_CACHE{

        @Override
        public <T> T execute(CachedHttpService cachedHttpService, Parser parser) {
            return cachedHttpService.executeRequest(parser);
        }
    }
    ,
    CACHE_FIRST{

        @Override
        public <T> T execute(CachedHttpService cachedHttpService, Parser parser) {
            Object response = cachedHttpService.readFromCache(parser);
            if (response == null) {
                response = cachedHttpService.executeRequest(parser);
            }
            return response;
        }
    }
    ,
    CACHE_FIRST_ASYNCH_REMOTE{

        @Override
        public <T> T execute(final CachedHttpService cachedHttpService, final Parser parser) {
            Object response = cachedHttpService.readFromCache(parser);
            if (response == null) {
                response = cachedHttpService.executeRequest(parser);
            } else {
                ExecutorUtils.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cachedHttpService.executeRequest(parser);
                        }
                        catch (Exception e) {
                            LoggerUtils.logHandledException(LOGGER, e);
                        }
                    }
                });
            }
            return response;
        }
    }
    ,
    CACHE_FORCED_FIRST_ASYNCH_REMOTE{

        @Override
        public <T> T execute(final CachedHttpService cachedHttpService, final Parser parser) {
            Long originalTimeToLive = cachedHttpService.getTimeToLive();
            cachedHttpService.setTimeToLive(null);
            Object response = cachedHttpService.readFromCache(parser);
            if (response == null) {
                response = cachedHttpService.executeRequest(parser);
            } else {
                cachedHttpService.setTimeToLive(originalTimeToLive);
                ExecutorUtils.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CACHE_FIRST.execute(cachedHttpService, parser);
                        }
                        catch (Exception e) {
                            LoggerUtils.logHandledException(LOGGER, e);
                        }
                    }
                });
            }
            return response;
        }
    }
    ,
    CACHE_ONLY{

        @Override
        public <T> T execute(CachedHttpService cachedHttpService, Parser parser) {
            return cachedHttpService.readFromCache(parser);
        }
    }
    ,
    REMOTE_FIRST{

        @Override
        public <T> T execute(CachedHttpService cachedHttpService, Parser parser) {
            T response = null;
            try {
                response = cachedHttpService.executeRequest(parser);
            }
            catch (Exception e) {
                LoggerUtils.logHandledException(LOGGER, e);
            }
            if (response == null) {
                response = cachedHttpService.readFromCache(parser);
            }
            if (response == null && parser != null) {
                throw new UnexpectedException("The service was expecting a response, but it was null (CachingStrategy.REMOTE_FIRST)");
            }
            return response;
        }
    };

    private static final Logger LOGGER;

    public abstract <T> T execute(CachedHttpService var1, Parser var2);

    static {
        LOGGER = LoggerUtils.getLogger(CachingStrategy.class);
    }
}

