/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.utils.EncryptionUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum Hasher {
    SHA_1("SHA-1"),
    SHA_512("SHA-512");

    private String algorithm;

    private Hasher(String algorithm) {
        this.algorithm = algorithm;
    }

    public String hash(String value) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            messageDigest.reset();
            messageDigest.update(value.getBytes());
            byte[] hashed = messageDigest.digest();
            return EncryptionUtils.toHex(hashed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedException(e);
        }
    }

    public Boolean isSupported() {
        try {
            MessageDigest.getInstance(this.algorithm);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static Hasher getSupportedHasher() {
        if (SHA_512.isSupported().booleanValue()) {
            return SHA_512;
        }
        return SHA_1;
    }
}

