/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.exception;

import com.jdroid.java.exception.ErrorCode;
import com.jdroid.java.exception.ErrorCodeException;

public enum CommonErrorCode implements ErrorCode
{
    CONNECTION_ERROR(null),
    UNEXPECTED_ERROR(null),
    HTTP_RESPONSE_ERROR(null);

    private Integer resourceId;
    private Integer statusCode;

    private CommonErrorCode(Integer resourceId, Integer statusCode) {
        this.resourceId = resourceId;
        this.statusCode = statusCode;
    }

    private CommonErrorCode(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public static ErrorCode findByStatusCode(String statusCode) {
        CommonErrorCode errorCode = null;
        for (CommonErrorCode each : CommonErrorCode.values()) {
            if (each.statusCode == null || !each.statusCode.toString().equals(statusCode)) continue;
            errorCode = each;
            break;
        }
        return errorCode;
    }

    @Override
    public String getStatusCode() {
        return this.statusCode.toString();
    }

    @Override
    public Integer getTitleResId() {
        return null;
    }

    @Override
    public Integer getDescriptionResId() {
        return this.resourceId;
    }

    @Override
    public ErrorCodeException newErrorCodeException(Object ... errorCodeParameters) {
        return new ErrorCodeException((ErrorCode)this, errorCodeParameters);
    }

    @Override
    public ErrorCodeException newErrorCodeException() {
        return new ErrorCodeException(this);
    }

    @Override
    public ErrorCodeException newErrorCodeException(Throwable throwable) {
        return new ErrorCodeException((ErrorCode)this, throwable);
    }

    @Override
    public ErrorCodeException newErrorCodeException(String message) {
        return new ErrorCodeException((ErrorCode)this, message);
    }
}

