/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http;

import com.jdroid.java.exception.ErrorCode;
import com.jdroid.java.exception.HttpResponseException;
import com.jdroid.java.http.BasicHttpResponseValidator;
import com.jdroid.java.http.HttpResponseWrapper;
import com.jdroid.java.utils.LoggerUtils;
import org.slf4j.Logger;

public abstract class AbstractHttpResponseValidator
extends BasicHttpResponseValidator {
    private static final Logger LOGGER = LoggerUtils.getLogger(AbstractHttpResponseValidator.class);
    private static final String STATUS_CODE_HEADER = "status-code";
    private static final String SUCCESSFUL_STATUS_CODE = "200";

    @Override
    protected void onSuccess(HttpResponseWrapper httpResponse, String message) {
        ErrorCode errorCode = this.getErrorCode(httpResponse);
        if (errorCode != null) {
            throw errorCode.newErrorCodeException();
        }
    }

    @Override
    protected void onClientError(HttpResponseWrapper httpResponse, String message) {
        ErrorCode errorCode = this.getErrorCode(httpResponse);
        if (errorCode != null) {
            throw errorCode.newErrorCodeException();
        }
        throw new HttpResponseException(message);
    }

    private ErrorCode getErrorCode(HttpResponseWrapper httpResponse) {
        ErrorCode errorCode = null;
        String statusCode = httpResponse.getHeader(STATUS_CODE_HEADER);
        if (statusCode != null) {
            LOGGER.debug("Server Status code: " + statusCode);
            if (!statusCode.equals(SUCCESSFUL_STATUS_CODE) && (errorCode = this.findByStatusCode(statusCode)) == null && (errorCode = this.findByCommonStatusCode(statusCode)) == null) {
                LOGGER.warn("Unknown Server Status code: " + statusCode);
                throw new HttpResponseException("Unknown Server Status code: " + statusCode);
            }
        }
        return errorCode;
    }

    protected abstract ErrorCode findByCommonStatusCode(String var1);

    protected abstract ErrorCode findByStatusCode(String var1);
}

