/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.mock;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.concurrent.ExecutorUtils;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.HttpResponseWrapper;
import com.jdroid.java.http.HttpServiceProcessor;
import com.jdroid.java.http.MultipartHttpService;
import com.jdroid.java.http.parser.Parser;
import com.jdroid.java.utils.FileUtils;
import com.jdroid.java.utils.LoggerUtils;
import com.jdroid.java.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractMockHttpService
implements MultipartHttpService {
    private static final Logger LOGGER = LoggerUtils.getLogger(AbstractMockHttpService.class);
    private static final String MOCK_SEPARATOR = "_";
    private static final String SUFFIX_SEPARATOR = "-";
    private static final String URL_SEPARATOR = "/";
    private List<Object> urlSegments;
    private Map<String, String> parameters = Maps.newHashMap();
    private Map<String, String> headers = Maps.newHashMap();
    private String body;

    public AbstractMockHttpService(Object ... urlSegments) {
        this.urlSegments = Lists.newArrayList();
        if (urlSegments != null) {
            for (Object segment : urlSegments) {
                this.addUrlSegment(segment);
            }
        }
    }

    @Override
    public <T> T execute(Parser parser) {
        Integer httpMockSleep;
        String filePath = this.generateMockFilePath(this.urlSegments);
        LOGGER.warn("Request: " + filePath);
        if (!this.parameters.isEmpty()) {
            LOGGER.warn("Parameters: " + this.parameters.toString());
        }
        if (!this.headers.isEmpty()) {
            LOGGER.warn("Headers: " + this.headers.toString());
        }
        if (StringUtils.isNotBlank(this.body)) {
            LOGGER.warn("HTTP Entity Body: " + this.body);
        }
        if ((httpMockSleep = this.getHttpMockSleepDuration(this.urlSegments.toArray())) != null && httpMockSleep > 0) {
            ExecutorUtils.sleep(httpMockSleep);
        }
        this.simulateCrash();
        if (parser != null) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
            if (inputStream == null) {
                throw new UnexpectedException("The mocked file wasn't found");
            }
            Object t = parser.parse(inputStream);
            FileUtils.safeClose(inputStream);
            return (T)t;
        }
        return null;
    }

    @Override
    public void execute() {
        this.execute(null);
    }

    protected void simulateCrash() {
    }

    @Override
    public void addHeader(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        }
    }

    @Override
    public void addQueryParameter(String name, Object value) {
        if (value != null) {
            this.parameters.put(name, value.toString());
        }
    }

    @Override
    public void addQueryParameter(String name, Collection<?> values) {
        this.addQueryParameter(name, StringUtils.join(values));
    }

    @Override
    public void addPart(String name, ByteArrayInputStream in, String mimeType, String filename) {
    }

    @Override
    public void addPart(String name, Object value, String mimeType) {
    }

    @Override
    public void addJsonPart(String name, Object value) {
    }

    @Override
    public void addUrlSegment(Object segment) {
        String segmentString = segment.toString();
        if (StringUtils.isNotEmpty(segmentString).booleanValue()) {
            this.urlSegments.add(segmentString);
        }
    }

    @Override
    public void addHttpServiceProcessor(HttpServiceProcessor httpServiceProcessor) {
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public void setConnectionTimeout(Integer connectionTimeout) {
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
    }

    @Override
    public void setWriteTimeout(Integer writeTimeout) {
    }

    @Override
    public void setUserAgent(String userAgent) {
    }

    @Override
    public void setSsl(Boolean ssl) {
    }

    protected abstract Integer getHttpMockSleepDuration(Object ... var1);

    @Override
    public String getUrl() {
        return this.generateMockFilePath(this.urlSegments);
    }

    @Override
    public String getUrlSuffix() {
        return null;
    }

    protected String generateMockFilePath(List<Object> urlSegments) {
        StringBuilder sb = new StringBuilder(this.getMocksBasePath());
        if (urlSegments != null) {
            for (Object urlSegment : urlSegments) {
                sb.append(urlSegment.toString().replaceAll(URL_SEPARATOR, MOCK_SEPARATOR));
                sb.append(MOCK_SEPARATOR);
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        String suffix = this.getSuffix(sb.toString());
        if (StringUtils.isNotBlank(suffix)) {
            sb.append(SUFFIX_SEPARATOR);
            sb.append(suffix);
        }
        sb.append(this.getMocksExtension());
        return sb.toString();
    }

    protected abstract String getMocksBasePath();

    protected abstract String getMocksExtension();

    protected String getSuffix(String path) {
        return null;
    }

    @Override
    public String getHeaderValue(String key) {
        return this.headers.get(key);
    }

    @Override
    public HttpResponseWrapper getHttpResponseWrapper() {
        return null;
    }
}

