/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.http.parser.zip;

import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.http.parser.Parser;
import com.jdroid.java.utils.LoggerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;

public class ZipFileParser
implements Parser {
    private static final Logger LOGGER = LoggerUtils.getLogger(ZipFileParser.class);
    private Parser innerParser;
    private String fileName;

    public ZipFileParser(Parser innerParser, String fileName) {
        this.innerParser = innerParser;
        this.fileName = fileName;
    }

    @Override
    public Object parse(InputStream inputStream) {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.getName().equals(this.fileName)) continue;
                LOGGER.debug("Starting to parse " + this.fileName + " file.");
                return this.innerParser.parse(zipInputStream);
            }
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
        return null;
    }

    @Override
    public Object parse(String input) {
        return null;
    }
}

