/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.marshaller;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.json.JSONArray;
import com.jdroid.java.marshaller.DefaultMarshaller;
import com.jdroid.java.marshaller.Marshaller;
import com.jdroid.java.marshaller.MarshallerMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MarshallerProvider {
    private Map<Class<?>, Marshaller<Object, Object>> marshallers = Maps.newHashMap();
    private Marshaller<Object, Object> defaultMarshaller = new DefaultMarshaller();
    private MarshallerTypeEvaluator marshallerTypeEvaluator = new DefaultMarshallerTypeEvaluator();
    private static final MarshallerProvider INSTANCE = new MarshallerProvider();

    private MarshallerProvider() {
    }

    public static MarshallerProvider get() {
        return INSTANCE;
    }

    public Object marshall(Object object, MarshallerMode mode, Map<String, String> extras) {
        if (object != null) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList<Object> list = Lists.newArrayList();
                for (Object each : collection) {
                    list.add(this.innerMarshall(each, mode, extras));
                }
                return new JSONArray(list);
            }
            return this.innerMarshall(object, mode, extras);
        }
        return null;
    }

    public Object innerMarshall(Object object, MarshallerMode mode, Map<String, String> extras) {
        if (object != null) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList<Object> list = Lists.newArrayList();
                for (Object each : collection) {
                    list.add(this.innerMarshall(each, mode, extras));
                }
                return list;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                if (map.isEmpty()) {
                    return null;
                }
                HashMap marshalledMap = Maps.newHashMap();
                for (Map.Entry entry : map.entrySet()) {
                    marshalledMap.put(entry.getKey(), this.innerMarshall(entry.getValue(), mode, extras));
                }
                return marshalledMap;
            }
            return this.getMarshaller(object).marshall(object, mode, extras);
        }
        return null;
    }

    public Marshaller<Object, Object> getMarshaller(Object marshallerType) {
        Class<?> clazz = this.marshallerTypeEvaluator.evaluate(marshallerType);
        return this.marshallers.containsKey(clazz) ? this.marshallers.get(clazz) : this.defaultMarshaller;
    }

    public void setMarshallers(Map<Class<?>, Marshaller<Object, Object>> marshallers) {
        this.marshallers = marshallers;
    }

    public void addMarshaller(Class<?> clazz, Marshaller<? extends Object, ? extends Object> marshaller) {
        this.marshallers.put(clazz, marshaller);
    }

    public void setMarshallerTypeEvaluator(MarshallerTypeEvaluator marshallerTypeEvaluator) {
        this.marshallerTypeEvaluator = marshallerTypeEvaluator;
    }

    public void setDefaultMarshaller(Marshaller<Object, Object> defaultMarshaller) {
        this.defaultMarshaller = defaultMarshaller;
    }

    private class DefaultMarshallerTypeEvaluator
    implements MarshallerTypeEvaluator {
        private DefaultMarshallerTypeEvaluator() {
        }

        @Override
        public Class<?> evaluate(Object marshallerType) {
            return marshallerType.getClass();
        }
    }

    public static interface MarshallerTypeEvaluator {
        public Class<?> evaluate(Object var1);
    }
}

