/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.repository;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.collections.Maps;
import com.jdroid.java.domain.Identifiable;
import com.jdroid.java.repository.Repository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class CacheWrapperRepository<T extends Identifiable>
implements Repository<T> {
    private static final Logger LOGGER = LoggerUtils.getLogger(CacheWrapperRepository.class);
    private Repository<T> wrappedRepository;
    private Map<String, T> cache;
    private Boolean synced;

    public CacheWrapperRepository(Repository<T> wrappedRepository) {
        this.wrappedRepository = wrappedRepository;
        this.cache = this.createCacheMap();
        this.synced = false;
    }

    protected Map<String, T> createCacheMap() {
        return Maps.newConcurrentHashMap();
    }

    protected Map<String, T> getCache() {
        return this.cache;
    }

    public List<T> getCachedItems() {
        return Lists.newArrayList(this.cache.values());
    }

    protected Repository<T> getWrappedRepository() {
        return this.wrappedRepository;
    }

    protected Boolean isSynced() {
        return this.synced;
    }

    @Override
    public T get(String id) {
        Identifiable item = (Identifiable)this.cache.get(id);
        if (item == null) {
            item = this.wrappedRepository.get(id);
            if (item != null) {
                this.cache.put(id, item);
            }
        } else {
            LOGGER.info("Retrieved object: " + item.getClass().getSimpleName() + ". [ " + item + " ]");
        }
        return (T)item;
    }

    @Override
    public void add(T item) {
        this.wrappedRepository.add(item);
        this.cache.put(item.getId(), item);
    }

    @Override
    public void addAll(Collection<T> items) {
        this.wrappedRepository.addAll(items);
        for (Identifiable each : items) {
            this.cache.put(each.getId(), each);
        }
    }

    @Override
    public void update(T item) {
        this.wrappedRepository.update(item);
        this.cache.put(item.getId(), item);
    }

    @Override
    public void remove(T item) {
        this.wrappedRepository.remove(item);
        this.cache.remove(item.getId());
    }

    @Override
    public void removeAll() {
        this.wrappedRepository.removeAll();
        this.cache.clear();
    }

    @Override
    public void removeAll(Collection<T> items) {
        this.wrappedRepository.removeAll(items);
        for (Identifiable each : items) {
            this.cache.remove(each.getId());
        }
    }

    @Override
    public List<T> findByField(String fieldName, Object ... values) {
        return this.wrappedRepository.findByField(fieldName, values);
    }

    @Override
    public List<T> getAll() {
        if (this.synced.booleanValue()) {
            ArrayList<T> items = Lists.newArrayList(this.cache.values());
            LOGGER.info("Retrieved all objects [" + items.size() + "]");
            return items;
        }
        List<T> items = this.wrappedRepository.getAll();
        for (Identifiable each : items) {
            this.cache.put(each.getId(), each);
        }
        this.synced = true;
        return items;
    }

    @Override
    public List<T> getAll(List<String> ids) {
        if (this.synced.booleanValue()) {
            ArrayList<T> items = Lists.newArrayList();
            for (String each : ids) {
                items.add(this.cache.get(each));
            }
            LOGGER.info("Retrieved all objects [" + items.size() + "] with ids: " + ids);
            return items;
        }
        List<T> items = this.wrappedRepository.getAll(ids);
        for (Identifiable each : items) {
            this.cache.put(each.getId(), each);
        }
        return items;
    }

    @Override
    public void remove(String id) {
        this.wrappedRepository.remove(id);
        this.cache.remove(id);
    }

    @Override
    public Boolean isEmpty() {
        Boolean isEmpty;
        if (this.synced.booleanValue()) {
            return this.cache.isEmpty();
        }
        this.synced = isEmpty = this.wrappedRepository.isEmpty();
        return isEmpty;
    }

    @Override
    public Long getSize() {
        if (this.synced.booleanValue()) {
            return this.cache.size();
        }
        Long size = this.wrappedRepository.getSize();
        this.synced = size == 0L;
        return size;
    }

    @Override
    public void replaceAll(Collection<T> items) {
        this.wrappedRepository.replaceAll(items);
        for (Identifiable each : items) {
            this.cache.put(each.getId(), each);
        }
    }

    @Override
    public T getUniqueInstance() {
        if (!this.cache.isEmpty()) {
            return (T)((Identifiable)this.cache.values().iterator().next());
        }
        T item = this.wrappedRepository.getUniqueInstance();
        this.cache.put(item.getId(), item);
        return item;
    }

    public void clearCache() {
        this.cache.clear();
    }
}

