/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.collections.Lists;
import com.jdroid.java.logger.MuteLogger;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static boolean enabled = false;
    private static ExceptionLogger exceptionLogger;
    private static final Logger MUTE_LOGGER;
    private static List<String> DISABLED_LOGGERS;
    private static ILoggerFactory DEFAULT_LOGGER_FACTORY;

    public static Logger getLogger(Object name) {
        return LoggerUtils.getLogger(name.getClass());
    }

    public static Logger getLogger(Class<?> clazz) {
        if (enabled) {
            String loggerName = LoggerUtils.getLoggerName(clazz);
            if (!DISABLED_LOGGERS.contains(loggerName)) {
                if (DEFAULT_LOGGER_FACTORY != null) {
                    return DEFAULT_LOGGER_FACTORY.getLogger(loggerName);
                }
                return LoggerFactory.getLogger((String)loggerName);
            }
            return MUTE_LOGGER;
        }
        return MUTE_LOGGER;
    }

    private static String getLoggerName(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.substring(0, Math.min(simpleName.length(), 23));
    }

    public static void setEnabled(boolean enabled) {
        LoggerUtils.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setDefaultLoggerFactory(ILoggerFactory defaultLoggerFactory) {
        DEFAULT_LOGGER_FACTORY = defaultLoggerFactory;
    }

    public static void addDisabledLogger(Class<?> clazz) {
        DISABLED_LOGGERS.add(LoggerUtils.getLoggerName(clazz));
    }

    public static void logHandledException(Logger defaultLogger, Exception e) {
        if (exceptionLogger != null) {
            exceptionLogger.logHandledException(e);
        } else {
            defaultLogger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void setExceptionLogger(ExceptionLogger exceptionLogger) {
        LoggerUtils.exceptionLogger = exceptionLogger;
    }

    static {
        MUTE_LOGGER = new MuteLogger();
        DISABLED_LOGGERS = Lists.newArrayList();
    }

    public static interface ExceptionLogger {
        public void logHandledException(Throwable var1);
    }
}

