/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.utils;

import com.jdroid.java.utils.StringUtils;
import java.text.DecimalFormat;

public class NumberUtils {
    public static Float getFloat(String value) {
        return NumberUtils.getFloat(value, null);
    }

    public static Float getFloat(String value, Float defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Float.valueOf(value) : defaultValue;
    }

    public static Integer getInteger(String value) {
        return NumberUtils.getInteger(value, null);
    }

    public static Integer getInteger(String value, Integer defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Integer.valueOf(value) : defaultValue;
    }

    public static Integer getSafeInteger(String value) {
        try {
            return NumberUtils.getInteger(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long getLong(String value) {
        return StringUtils.isNotEmpty(value) != false ? Long.valueOf(value) : null;
    }

    public static Long getSafeLong(String value) {
        try {
            return NumberUtils.getLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double getDouble(String value) {
        return StringUtils.isNotEmpty(value) != false ? Double.valueOf(value) : null;
    }

    public static Boolean getBooleanFromNumber(String value) {
        return StringUtils.isNotEmpty(value) != false ? Boolean.valueOf("1".equals(value)) : null;
    }

    public static Boolean getBoolean(String value) {
        return NumberUtils.getBoolean(value, null);
    }

    public static Boolean getBoolean(String value, Boolean defaultValue) {
        return StringUtils.isNotEmpty(value) != false ? Boolean.parseBoolean(value) : defaultValue;
    }

    public static String getString(Integer value) {
        return value != null ? value.toString() : null;
    }

    public static String formatThousand(String number) {
        if (StringUtils.isBlank(number)) {
            return "";
        }
        DecimalFormat decimalFormatter = new DecimalFormat();
        return decimalFormatter.format(Double.valueOf(number));
    }

    public static String getOrdinalSuffix(int n) {
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }
}

