/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import com.kttdevelopment.simplehttpserver.ContextUtil;
import com.kttdevelopment.simplehttpserver.HttpSession;
import com.kttdevelopment.simplehttpserver.HttpSessionHandler;
import com.kttdevelopment.simplehttpserver.SimpleHttpExchange;
import com.kttdevelopment.simplehttpserver.SimpleHttpServer;
import com.kttdevelopment.simplehttpserver.handler.RootHandler;
import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;

final class SimpleHttpServerImpl
extends SimpleHttpServer {
    private final HttpServer server = HttpServer.create();
    private HttpSessionHandler sessionHandler;
    private final Map<HttpContext, HttpHandler> contexts = new HashMap<HttpContext, HttpHandler>();
    private boolean running = false;

    static SimpleHttpServer createHttpServer(Integer port, Integer backlog) throws IOException {
        return new SimpleHttpServerImpl(port, backlog);
    }

    SimpleHttpServerImpl(Integer port, Integer backlog) throws IOException {
        if (port != null) {
            this.server.bind(new InetSocketAddress(port), backlog != null ? backlog : 0);
        }
    }

    private void handle(HttpExchange exchange) {
        if (this.sessionHandler != null) {
            this.sessionHandler.getSession(exchange).updateLastAccessTime();
        }
    }

    @Override
    public final HttpServer getHttpServer() {
        return this.server;
    }

    @Override
    public final synchronized InetSocketAddress bind(int port) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(port);
        this.server.bind(addr, 0);
        return addr;
    }

    @Override
    public final synchronized InetSocketAddress bind(int port, int backlog) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(port);
        this.server.bind(addr, backlog);
        return addr;
    }

    @Override
    public final synchronized void bind(InetSocketAddress addr) throws IOException {
        this.server.bind(addr, 0);
    }

    @Override
    public final synchronized void bind(InetSocketAddress addr, int backlog) throws IOException {
        this.server.bind(addr, backlog);
    }

    @Override
    public final InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    @Override
    public final synchronized void setExecutor(Executor executor) {
        this.server.setExecutor(executor);
    }

    @Override
    public final Executor getExecutor() {
        return this.server.getExecutor();
    }

    @Override
    public final synchronized void setHttpSessionHandler(HttpSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    public final HttpSessionHandler getHttpSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public final HttpSession getHttpSession(HttpExchange exchange) {
        return this.sessionHandler != null ? this.sessionHandler.getSession(exchange) : null;
    }

    @Override
    public final HttpSession getHttpSession(SimpleHttpExchange exchange) {
        return this.getHttpSession(exchange.getHttpExchange());
    }

    @Override
    public final synchronized HttpContext createContext(String context) {
        return this.createContext(context, HttpExchange::close, null);
    }

    @Override
    public final synchronized HttpContext createContext(String context, HttpHandler handler) {
        return this.createContext(context, handler, null);
    }

    @Override
    public final synchronized HttpContext createContext(String context, Authenticator authenticator) {
        return this.createContext(context, HttpExchange::close, authenticator);
    }

    @Override
    public final synchronized HttpContext createContext(String context, HttpHandler handler, Authenticator authenticator) {
        String ct = ContextUtil.getContext(context, true, false);
        if (!ct.equals("/") && handler instanceof RootHandler) {
            throw new IllegalArgumentException("RootHandler can only be used at the root '/' context");
        }
        HttpHandler wrapper = exchange -> {
            this.handle(exchange);
            handler.handle(exchange);
        };
        HttpContext hc = this.server.createContext(ct);
        hc.setHandler(wrapper);
        this.contexts.put(hc, handler);
        if (authenticator != null) {
            hc.setAuthenticator(authenticator);
        }
        return hc;
    }

    @Override
    public final synchronized void removeContext(String context) {
        try {
            this.server.removeContext(ContextUtil.getContext(context, true, false));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            for (HttpContext hc : this.contexts.keySet()) {
                if (!hc.getPath().equalsIgnoreCase(ContextUtil.getContext(context, true, false))) continue;
                this.contexts.remove(hc);
                break;
            }
        }
    }

    @Override
    public final synchronized void removeContext(HttpContext context) {
        this.contexts.remove(context);
        this.server.removeContext(context);
    }

    @Override
    public final HttpHandler getContextHandler(String context) {
        for (Map.Entry<HttpContext, HttpHandler> entry : this.contexts.entrySet()) {
            if (!entry.getKey().getPath().equals(ContextUtil.getContext(context, true, false))) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public final HttpHandler getContextHandler(HttpContext context) {
        return this.contexts.get(context);
    }

    @Override
    public final Map<HttpContext, HttpHandler> getContexts() {
        return new HashMap<HttpContext, HttpHandler>(this.contexts);
    }

    @Override
    public final synchronized String getRandomContext() {
        return this.getRandomContext("");
    }

    @Override
    public final synchronized String getRandomContext(String context) {
        String targetContext;
        String head;
        String string = head = context.isEmpty() ? "" : ContextUtil.getContext(context, true, false);
        while (this.getContextHandler(targetContext = head + ContextUtil.getContext(UUID.randomUUID().toString(), true, false)) != null) {
        }
        return targetContext;
    }

    @Override
    public final synchronized void start() {
        if (!this.running) {
            this.server.start();
            this.running = true;
        }
    }

    @Override
    public final synchronized void stop() {
        this.stop(0);
    }

    @Override
    public final synchronized void stop(int delay) {
        if (this.running) {
            this.running = false;
            this.server.stop(delay);
        }
    }

    public String toString() {
        return "SimpleHttpServer{httpServer=" + this.server + ", contexts=" + this.contexts + ", address=" + this.getAddress() + ", executor=" + this.getExecutor() + "}";
    }
}

