/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.metaobjects.generator.direct.metadata.ai.MetaDataAIDocumentationWriter;
import com.metaobjects.generator.direct.metadata.file.json.MetaDataFileSchemaWriter;
import com.metaobjects.generator.direct.metadata.file.xsd.MetaDataFileXSDWriter;
import com.metaobjects.registry.MetaDataRegistry;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingSchemaGeneratorTest {
    private static final Logger log = LoggerFactory.getLogger(WorkingSchemaGeneratorTest.class);
    private MetaDataRegistry registry;

    @Before
    public void setUp() {
        this.registry = MetaDataRegistry.getInstance();
        try {
            Class.forName("com.metaobjects.field.StringField");
            Class.forName("com.metaobjects.field.IntegerField");
            Class.forName("com.metaobjects.object.MetaObject");
        }
        catch (ClassNotFoundException e) {
            log.warn("Some core types not available for testing: {}", (Object)e.getMessage());
        }
        log.info("Test setup completed with {} registered types", (Object)this.registry.getRegisteredTypes().size());
        log.info("Available types: {}", (Object)this.registry.getRegisteredTypeNames());
        log.info("Total constraints: {}", (Object)this.registry.getAllValidationConstraints().size());
    }

    @Test
    public void generateWorkingSchemas() throws Exception {
        block38: {
            FileWriter writer;
            block36: {
                block34: {
                    log.info("=== GENERATING WORKING SCHEMAS ===");
                    log.info("Generating AI documentation...");
                    try (ByteArrayOutputStream aiStream = new ByteArrayOutputStream();){
                        MetaDataAIDocumentationWriter aiWriter = new MetaDataAIDocumentationWriter(null, (OutputStream)aiStream);
                        aiWriter.withInheritance(true).withExtensionGuidance(true).withCrossLanguageInfo(true);
                        aiWriter.writeJson();
                        aiWriter.close();
                        String aiJson = aiStream.toString();
                        if (!aiJson.trim().isEmpty()) {
                            writer = new FileWriter("target/working-ai-documentation.json");
                            try {
                                writer.write(aiJson);
                            }
                            finally {
                                writer.close();
                            }
                            log.info("\u2705 Generated AI documentation: {} bytes -> target/working-ai-documentation.json", (Object)aiJson.length());
                            Gson gson = new GsonBuilder().setPrettyPrinting().create();
                            JsonObject doc = (JsonObject)gson.fromJson(aiJson, JsonObject.class);
                            JsonObject docInfo = doc.getAsJsonObject("documentationInfo");
                            log.info("AI Doc Summary: {} types, {} inheritance relationships", (Object)docInfo.get("totalTypes").getAsInt(), (Object)(doc.has("inheritanceHierarchy") ? "yes" : "none"));
                            break block34;
                        }
                        log.warn("\u274c AI documentation is empty");
                    }
                }
                log.info("Generating JSON schema...");
                try (ByteArrayOutputStream jsonStream = new ByteArrayOutputStream();){
                    MetaDataFileSchemaWriter jsonWriter = new MetaDataFileSchemaWriter(null, (OutputStream)jsonStream);
                    jsonWriter.writeJson();
                    jsonWriter.close();
                    String jsonSchema = jsonStream.toString();
                    if (!jsonSchema.trim().isEmpty()) {
                        writer = new FileWriter("target/working-metadata-schema.json");
                        try {
                            writer.write(jsonSchema);
                        }
                        finally {
                            writer.close();
                        }
                        log.info("\u2705 Generated JSON schema: {} bytes -> target/working-metadata-schema.json", (Object)jsonSchema.length());
                        break block36;
                    }
                    log.warn("\u274c JSON schema is empty");
                }
            }
            log.info("Generating XSD schema...");
            try (ByteArrayOutputStream xsdStream = new ByteArrayOutputStream();){
                MetaDataFileXSDWriter xsdWriter = new MetaDataFileXSDWriter(null, (OutputStream)xsdStream);
                xsdWriter.writeXML();
                xsdWriter.close();
                String xsdSchema = xsdStream.toString();
                if (!xsdSchema.trim().isEmpty()) {
                    writer = new FileWriter("target/working-metadata-schema.xsd");
                    try {
                        writer.write(xsdSchema);
                    }
                    finally {
                        writer.close();
                    }
                    log.info("\u2705 Generated XSD schema: {} bytes -> target/working-metadata-schema.xsd", (Object)xsdSchema.length());
                    break block38;
                }
                log.warn("\u274c XSD schema is empty");
            }
        }
        log.info("=== SCHEMA GENERATION COMPLETED ===");
    }
}

