/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.jsonschema;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.file.json.MetaDataFileJsonSchemaGenerator;
import com.metaobjects.generator.direct.metadata.file.json.MetaDataFileSchemaWriter;
import com.metaobjects.loader.MetaDataLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetaDataJsonSchemaGeneratorTest {
    private MetaDataLoader testLoader;

    @Before
    public void setUp() {
        this.testLoader = MetaDataLoader.createManual((boolean)false, (String)"json-schema-test").init().register().getLoader();
    }

    @After
    public void tearDown() {
        if (this.testLoader != null) {
            this.testLoader.destroy();
            this.testLoader = null;
        }
    }

    @Test
    public void testJsonSchemaGeneration() throws GeneratorIOException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        MetaDataFileSchemaWriter writer = new MetaDataFileSchemaWriter(this.testLoader, (OutputStream)output).withSchemaVersion("https://json-schema.org/draft/2020-12/schema").withSchemaId("https://example.com/metadata-schema.json").withTitle("Test MetaData Schema").withDescription("Test schema for metadata validation");
        writer.writeJson();
        writer.close();
        String jsonOutput = output.toString(StandardCharsets.UTF_8);
        Assert.assertNotNull((String)"JSON output should not be null", (Object)jsonOutput);
        Assert.assertFalse((String)"JSON output should not be empty", (boolean)jsonOutput.trim().isEmpty());
        JsonObject schema = JsonParser.parseString((String)jsonOutput).getAsJsonObject();
        Assert.assertTrue((String)"Schema should have $schema property", (boolean)schema.has("$schema"));
        Assert.assertEquals((Object)"https://json-schema.org/draft/2020-12/schema", (Object)schema.get("$schema").getAsString());
        Assert.assertTrue((String)"Schema should have $id property", (boolean)schema.has("$id"));
        Assert.assertEquals((Object)"https://example.com/metadata-schema.json", (Object)schema.get("$id").getAsString());
        Assert.assertTrue((String)"Schema should have title property", (boolean)schema.has("title"));
        Assert.assertEquals((Object)"Test MetaData Schema", (Object)schema.get("title").getAsString());
        Assert.assertTrue((String)"Schema should have description property", (boolean)schema.has("description"));
        Assert.assertEquals((Object)"Test schema for metadata validation", (Object)schema.get("description").getAsString());
        Assert.assertTrue((String)"Schema should have type property", (boolean)schema.has("type"));
        Assert.assertEquals((Object)"object", (Object)schema.get("type").getAsString());
        Assert.assertTrue((String)"Schema should have $defs property", (boolean)schema.has("$defs"));
        Assert.assertTrue((String)"Schema should have properties", (boolean)schema.has("properties"));
    }

    @Test
    public void testGeneratorConfiguration() {
        MetaDataFileJsonSchemaGenerator generator = new MetaDataFileJsonSchemaGenerator();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("schemaVersion", "https://json-schema.org/draft/2019-09/schema");
        args.put("schemaId", "https://test.com/schema.json");
        args.put("title", "Custom Title");
        args.put("description", "Custom Description");
        generator.setArgs(args);
        String toString = generator.toString();
        Assert.assertTrue((String)"toString should include class name", (boolean)toString.contains("MetaDataFileJsonSchemaGenerator"));
    }

    @Test
    public void testWriterConfiguration() throws GeneratorIOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        MetaDataFileSchemaWriter writer = new MetaDataFileSchemaWriter(this.testLoader, (OutputStream)output).withSchemaVersion("custom-version").withSchemaId("custom-id").withTitle("custom-title").withDescription("custom-description");
        String toString = writer.toString();
        Assert.assertTrue((String)"toString should include schema version", (boolean)toString.contains("custom-version"));
        Assert.assertTrue((String)"toString should include schema id", (boolean)toString.contains("custom-id"));
    }

    @Test
    public void testMinimalConfiguration() throws GeneratorIOException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        MetaDataFileSchemaWriter writer = new MetaDataFileSchemaWriter(this.testLoader, (OutputStream)output);
        writer.writeJson();
        writer.close();
        String jsonOutput = output.toString(StandardCharsets.UTF_8);
        JsonObject schema = JsonParser.parseString((String)jsonOutput).getAsJsonObject();
        Assert.assertTrue((String)"Should have default schema version", (boolean)schema.has("$schema"));
        Assert.assertTrue((String)"Should have default title", (boolean)schema.has("title"));
        Assert.assertTrue((String)"Should have default description", (boolean)schema.has("description"));
        Assert.assertFalse((String)"Should not have $id when not specified", (schema.has("$id") && !schema.get("$id").isJsonNull() ? 1 : 0) != 0);
    }
}

