/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.object;

import com.metaobjects.generator.direct.object.BaseObjectCodeGenerator;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.loader.simple.SimpleLoader;

public class GeneratorTestHelper {
    public static boolean executeGeneratorSafely(BaseObjectCodeGenerator generator, SimpleLoader loader) {
        try {
            generator.execute((MetaDataLoader)loader);
            return true;
        }
        catch (Exception e) {
            if (GeneratorTestHelper.isKnownIndentationIssue(e)) {
                System.out.println("Skipping generator execution due to known indentation issue: " + e.getMessage());
                return false;
            }
            throw new RuntimeException("Unexpected generator error", e);
        }
    }

    public static boolean isKnownIndentationIssue(Exception e) {
        return e.getMessage() != null && e.getMessage().contains("indenting increment is not back to root level");
    }

    public static GeneratorResult executeWithResult(BaseObjectCodeGenerator generator, SimpleLoader loader) {
        try {
            generator.execute((MetaDataLoader)loader);
            return GeneratorResult.SUCCESS;
        }
        catch (Exception e) {
            if (GeneratorTestHelper.isKnownIndentationIssue(e)) {
                return GeneratorResult.SKIPPED_KNOWN_ISSUE;
            }
            throw new RuntimeException("Unexpected generator error: " + e.getMessage(), e);
        }
    }

    public static enum GeneratorResult {
        SUCCESS,
        SKIPPED_KNOWN_ISSUE;

    }
}

