/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator;

import com.metaobjects.MetaData;
import com.metaobjects.MetaDataException;
import com.metaobjects.util.ErrorFormatter;
import java.util.HashMap;
import java.util.Map;

public class GeneratorException
extends MetaDataException {
    public GeneratorException(String msg) {
        super(msg);
    }

    public GeneratorException(String msg, Exception e) {
        super(msg, (Throwable)e);
    }

    public GeneratorException(String message, MetaData source, String operation) {
        super(message, source, operation);
    }

    public GeneratorException(String message, MetaData source, String operation, Throwable cause, Map<String, Object> additionalContext) {
        super(message, source, operation, cause, additionalContext);
    }

    public static GeneratorException forTemplate(String templateName, MetaData source, Throwable cause) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"templateProcessing", (String)String.format("Failed to process template '%s'", templateName), Map.of("templateName", templateName));
        return new GeneratorException(message, source, "templateProcessing", cause, Map.of("templateName", templateName, "errorType", "template"));
    }

    public static GeneratorException forCodeGeneration(String generatorType, String targetFile, MetaData source, Throwable cause) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"codeGeneration", (String)String.format("Failed to generate %s code for '%s'", generatorType, targetFile), Map.of("generatorType", generatorType, "targetFile", targetFile));
        return new GeneratorException(message, source, "codeGeneration", cause, Map.of("generatorType", generatorType, "targetFile", targetFile, "errorType", "codeGeneration"));
    }

    public static GeneratorException forConfiguration(String configProperty, Object configValue, String issue, MetaData source) {
        String message = ErrorFormatter.formatConfigurationError((MetaData)source, (String)configProperty, (Object)configValue, (String)issue);
        return new GeneratorException(message, source, "configuration", null, Map.of("configProperty", configProperty, "configValue", configValue != null ? configValue.toString() : "<null>", "issue", issue, "errorType", "configuration"));
    }

    public static GeneratorException forValidation(Map<String, String> validationErrors, MetaData source) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"metadataValidation", (String)"Metadata validation failed during generation", new HashMap<String, String>(validationErrors));
        return new GeneratorException(message, source, "metadataValidation", null, Map.of("validationErrors", validationErrors, "errorCount", validationErrors.size(), "errorType", "validation"));
    }

    public static GeneratorException forDependency(String dependencyType, String dependencyName, MetaData source) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"dependencyResolution", (String)String.format("Could not resolve %s dependency: %s", dependencyType, dependencyName), Map.of("dependencyType", dependencyType, "dependencyName", dependencyName));
        return new GeneratorException(message, source, "dependencyResolution", null, Map.of("dependencyType", dependencyType, "dependencyName", dependencyName, "errorType", "dependency"));
    }

    public static GeneratorException forSyntax(String syntaxError, String fileName, int lineNumber, MetaData source) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"syntaxValidation", (String)String.format("Syntax error in %s at line %d: %s", fileName, lineNumber, syntaxError), Map.of("fileName", fileName, "lineNumber", lineNumber, "syntaxError", syntaxError));
        return new GeneratorException(message, source, "syntaxValidation", null, Map.of("fileName", fileName, "lineNumber", lineNumber, "syntaxError", syntaxError, "errorType", "syntax"));
    }

    public static GeneratorException forFileSystem(String fileOperation, String filePath, MetaData source, Throwable cause) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"fileSystem", (String)String.format("File system operation '%s' failed for: %s", fileOperation, filePath), Map.of("fileOperation", fileOperation, "filePath", filePath));
        return new GeneratorException(message, source, "fileSystem", cause, Map.of("fileOperation", fileOperation, "filePath", filePath, "errorType", "fileSystem"));
    }
}

