/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.file.xsd;

import com.metaobjects.constraint.CustomConstraint;
import com.metaobjects.constraint.PlacementConstraint;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.xml.XMLDirectWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.MetaDataRegistry;
import com.metaobjects.registry.TypeDefinition;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetaDataFileXSDWriter
extends XMLDirectWriter<MetaDataFileXSDWriter> {
    private static final Logger log = LoggerFactory.getLogger(MetaDataFileXSDWriter.class);
    private String nameSpace;
    private String targetNamespace;
    private String elementFormDefault = "qualified";
    private MetaDataRegistry typeRegistry = MetaDataRegistry.getInstance();
    private List<PlacementConstraint> placementConstraints = new ArrayList<PlacementConstraint>();
    private List<CustomConstraint> validationConstraints = new ArrayList<CustomConstraint>();

    public MetaDataFileXSDWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        super(loader, out);
        log.info("Initialized registry-driven XSD writer with {} registered types", (Object)this.typeRegistry.getRegisteredTypes().size());
    }

    public MetaDataFileXSDWriter withNamespace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public MetaDataFileXSDWriter withTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
        return this;
    }

    public MetaDataFileXSDWriter withElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
        return this;
    }

    @Deprecated
    public MetaDataFileXSDWriter addConstraintFile(String constraintFile) {
        log.warn("Constraint files are deprecated - using registry-based type discovery instead");
        return this;
    }

    @Override
    public String toString() {
        return "MetaDataFileXSDWriter{nameSpace='" + this.nameSpace + "', targetNamespace='" + this.targetNamespace + "', elementFormDefault='" + this.elementFormDefault + "', registeredTypes=" + this.typeRegistry.getRegisteredTypes().size() + "}";
    }

    @Override
    public void writeXML() throws GeneratorIOException {
        try {
            this.loadConstraintDefinitions();
            Document xsdDoc = this.generateMetaDataFileXSD();
            Document doc = this.doc();
            Node importedRoot = doc.importNode(xsdDoc.getDocumentElement(), true);
            doc.appendChild(importedRoot);
        }
        catch (Exception e) {
            throw new GeneratorIOException(this, "Failed to generate metadata file XSD schema", e);
        }
    }

    private void loadConstraintDefinitions() {
        log.info("Loading registry data for XSD generation: {} types, {} constraints", (Object)this.typeRegistry.getRegisteredTypes().size(), (Object)this.typeRegistry.getAllValidationConstraints().size());
        this.placementConstraints = this.typeRegistry.getPlacementValidationConstraints();
        this.validationConstraints = this.typeRegistry.getFieldValidationConstraints();
        log.debug("Registry types: {}", (Object)this.typeRegistry.getRegisteredTypeNames());
    }

    private Document generateMetaDataFileXSD() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element schema = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
        doc.appendChild(schema);
        schema.setAttribute("xmlns:tns", this.targetNamespace != null ? this.targetNamespace : this.nameSpace);
        schema.setAttribute("elementFormDefault", this.elementFormDefault);
        schema.setAttribute("targetNamespace", this.targetNamespace != null ? this.targetNamespace : this.nameSpace);
        schema.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        Element metadataElement = doc.createElement("xs:element");
        metadataElement.setAttribute("name", "metadata");
        metadataElement.setAttribute("type", "MetaDataType");
        schema.appendChild(metadataElement);
        schema.appendChild(this.createMetaDataType(doc));
        schema.appendChild(this.createMetaDataChildType(doc));
        this.generateDynamicTypeDefinitions(doc, schema);
        schema.appendChild(this.createNameConstraintType(doc));
        return doc;
    }

    private Element createMetaDataType(Document doc) {
        Element complexType = doc.createElement("xs:complexType");
        complexType.setAttribute("name", "MetaDataType");
        Element annotation = doc.createElement("xs:annotation");
        Element documentation = doc.createElement("xs:documentation");
        documentation.setTextContent("Root metadata container with optional package and required children");
        annotation.appendChild(documentation);
        complexType.appendChild(annotation);
        Element sequence = doc.createElement("xs:sequence");
        complexType.appendChild(sequence);
        Element childrenElement = doc.createElement("xs:element");
        childrenElement.setAttribute("name", "children");
        childrenElement.setAttribute("minOccurs", "1");
        childrenElement.setAttribute("maxOccurs", "1");
        sequence.appendChild(childrenElement);
        Element childrenComplexType = doc.createElement("xs:complexType");
        childrenElement.appendChild(childrenComplexType);
        Element childrenSequence = doc.createElement("xs:sequence");
        childrenComplexType.appendChild(childrenSequence);
        Element childElement = doc.createElement("xs:element");
        childElement.setAttribute("name", "child");
        childElement.setAttribute("type", "MetaDataChildType");
        childElement.setAttribute("minOccurs", "0");
        childElement.setAttribute("maxOccurs", "unbounded");
        childrenSequence.appendChild(childElement);
        Element packageAttr = doc.createElement("xs:attribute");
        packageAttr.setAttribute("name", "package");
        packageAttr.setAttribute("type", "xs:string");
        packageAttr.setAttribute("use", "optional");
        complexType.appendChild(packageAttr);
        return complexType;
    }

    private Element createMetaDataChildType(Document doc) {
        Element complexType = doc.createElement("xs:complexType");
        complexType.setAttribute("name", "MetaDataChildType");
        Element choice = doc.createElement("xs:choice");
        complexType.appendChild(choice);
        Set primaryTypes = this.typeRegistry.getAllTypeDefinitions().stream().map(TypeDefinition::getType).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String primaryType : primaryTypes) {
            Element element = doc.createElement("xs:element");
            element.setAttribute("name", primaryType);
            element.setAttribute("type", this.capitalizeFirstLetter(primaryType) + "Type");
            choice.appendChild(element);
        }
        log.debug("Generated dynamic child choice for types: {}", (Object)primaryTypes);
        return complexType;
    }

    private void generateDynamicTypeDefinitions(Document doc, Element schema) {
        Map<String, List<TypeDefinition>> typeGroups = this.typeRegistry.getAllTypeDefinitions().stream().collect(Collectors.groupingBy(TypeDefinition::getType));
        for (Map.Entry<String, List<TypeDefinition>> entry : typeGroups.entrySet()) {
            String primaryType = entry.getKey();
            List<TypeDefinition> typeDefs = entry.getValue();
            Element complexType = this.createPrimaryTypeComplexType(doc, primaryType, typeDefs);
            schema.appendChild(complexType);
            Element enumType = this.createSubTypeEnumType(doc, primaryType, typeDefs);
            schema.appendChild(enumType);
            log.debug("Generated XSD types for '{}' with {} subtypes", (Object)primaryType, (Object)typeDefs.size());
        }
    }

    private Element createPrimaryTypeComplexType(Document doc, String primaryType, List<TypeDefinition> typeDefs) {
        Element complexType = doc.createElement("xs:complexType");
        complexType.setAttribute("name", this.capitalizeFirstLetter(primaryType) + "Type");
        Element annotation = this.createRegistryAnnotation(doc, primaryType, typeDefs);
        complexType.appendChild(annotation);
        if (this.hasChildRequirements(typeDefs)) {
            Element sequence = doc.createElement("xs:sequence");
            complexType.appendChild(sequence);
            Element childrenElement = doc.createElement("xs:element");
            childrenElement.setAttribute("name", "children");
            childrenElement.setAttribute("minOccurs", "0");
            childrenElement.setAttribute("maxOccurs", "1");
            sequence.appendChild(childrenElement);
            Element childrenComplexType = doc.createElement("xs:complexType");
            childrenElement.appendChild(childrenComplexType);
            Element childrenSequence = doc.createElement("xs:sequence");
            childrenComplexType.appendChild(childrenSequence);
            Element childElement = doc.createElement("xs:element");
            childElement.setAttribute("name", "child");
            childElement.setAttribute("type", "MetaDataChildType");
            childElement.setAttribute("minOccurs", "0");
            childElement.setAttribute("maxOccurs", "unbounded");
            childrenSequence.appendChild(childElement);
        }
        Element nameAttr = doc.createElement("xs:attribute");
        nameAttr.setAttribute("name", "name");
        nameAttr.setAttribute("type", "NameConstraintType");
        nameAttr.setAttribute("use", "required");
        complexType.appendChild(nameAttr);
        Element typeAttr = doc.createElement("xs:attribute");
        typeAttr.setAttribute("name", "subType");
        typeAttr.setAttribute("type", this.capitalizeFirstLetter(primaryType) + "TypeEnum");
        typeAttr.setAttribute("use", "required");
        complexType.appendChild(typeAttr);
        Element anyAttribute = doc.createElement("xs:anyAttribute");
        anyAttribute.setAttribute("processContents", "lax");
        Element anyAttrAnnotation = doc.createElement("xs:annotation");
        Element anyAttrDoc = doc.createElement("xs:documentation");
        anyAttrDoc.setTextContent("Inline attributes support: Additional attributes are allowed when attr type has default subType configured.");
        anyAttrAnnotation.appendChild(anyAttrDoc);
        anyAttribute.appendChild(anyAttrAnnotation);
        complexType.appendChild(anyAttribute);
        return complexType;
    }

    private Element createNameConstraintType(Document doc) {
        Element simpleType = doc.createElement("xs:simpleType");
        simpleType.setAttribute("name", "NameConstraintType");
        Element restriction = doc.createElement("xs:restriction");
        restriction.setAttribute("base", "xs:string");
        simpleType.appendChild(restriction);
        Element patternFacet = doc.createElement("xs:pattern");
        String xmlSchemaPattern = "^[a-zA-Z][a-zA-Z0-9_]*$".replaceAll("^\\^|\\$$", "");
        patternFacet.setAttribute("value", xmlSchemaPattern);
        restriction.appendChild(patternFacet);
        Element minLengthFacet = doc.createElement("xs:minLength");
        minLengthFacet.setAttribute("value", "1");
        restriction.appendChild(minLengthFacet);
        Element maxLengthFacet = doc.createElement("xs:maxLength");
        maxLengthFacet.setAttribute("value", "64");
        restriction.appendChild(maxLengthFacet);
        return simpleType;
    }

    private Element createSubTypeEnumType(Document doc, String primaryType, List<TypeDefinition> typeDefs) {
        Element simpleType = doc.createElement("xs:simpleType");
        simpleType.setAttribute("name", this.capitalizeFirstLetter(primaryType) + "TypeEnum");
        Element restriction = doc.createElement("xs:restriction");
        restriction.setAttribute("base", "xs:string");
        simpleType.appendChild(restriction);
        Set subTypes = typeDefs.stream().map(TypeDefinition::getSubType).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String subType : subTypes) {
            Element enumeration = doc.createElement("xs:enumeration");
            enumeration.setAttribute("value", subType);
            restriction.appendChild(enumeration);
        }
        log.debug("Generated enum for {}: {}", (Object)primaryType, (Object)subTypes);
        return simpleType;
    }

    private Element createRegistryAnnotation(Document doc, String primaryType, List<TypeDefinition> typeDefs) {
        Element annotation = doc.createElement("xs:annotation");
        Element documentation = doc.createElement("xs:documentation");
        StringBuilder info = new StringBuilder();
        info.append(String.format("%s type with %d registered subtypes from registry. ", this.capitalizeFirstLetter(primaryType), typeDefs.size()));
        List inheritedTypes = typeDefs.stream().filter(def -> def.hasParent()).collect(Collectors.toList());
        if (!inheritedTypes.isEmpty()) {
            info.append(String.format("Inheritance: %d types inherit from base types. ", inheritedTypes.size()));
        }
        Set subTypes = typeDefs.stream().map(TypeDefinition::getSubType).collect(Collectors.toCollection(LinkedHashSet::new));
        info.append(String.format("Subtypes: %s", String.join((CharSequence)", ", subTypes)));
        documentation.setTextContent(info.toString());
        annotation.appendChild(documentation);
        return annotation;
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private boolean hasChildRequirements(List<TypeDefinition> typeDefs) {
        return typeDefs.stream().anyMatch(def -> !def.getChildRequirements().isEmpty());
    }

    @Deprecated
    private Element createConstraintAnnotation(Document doc, String description) {
        return this.createRegistryAnnotation(doc, description, Collections.emptyList());
    }
}

