/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.html;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.html.MetaDataHtmlDocumentationWriter;
import com.metaobjects.generator.direct.metadata.html.SingleHtmlDirectGeneratorBase;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.MetaDataRegistry;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataHtmlDocumentationGenerator
extends SingleHtmlDirectGeneratorBase {
    private static final Logger log = LoggerFactory.getLogger(MetaDataHtmlDocumentationGenerator.class);
    private String version = "6.2.0";
    private String title = "MetaObjects Framework Documentation";
    private boolean includeInheritance = true;
    private boolean includeExamples = true;
    private boolean includeExtensionGuide = true;
    public static final String HTML_TITLE = "htmlTitle";
    public static final String HTML_DESCRIPTION = "htmlDescription";
    public static final String HTML_EXAMPLE = "htmlExample";
    public static final String HTML_USAGE_PATTERN = "htmlUsagePattern";
    public static final String HTML_EXTENSION_GUIDE = "htmlExtensionGuide";
    public static final String HTML_SEE_ALSO = "htmlSeeAlso";
    public static final String HTML_SINCE_VERSION = "htmlSinceVersion";
    public static final String HTML_DEPRECATED = "htmlDeprecated";

    public MetaDataHtmlDocumentationGenerator() {
        log.debug("Initialized HTML documentation generator with registry-based type discovery");
    }

    @Override
    protected MetaDataHtmlDocumentationWriter getWriter(MetaDataLoader loader, OutputStream os) throws GeneratorIOException {
        try {
            return new MetaDataHtmlDocumentationWriter(loader, os).withVersion(this.version).withTitle(this.title).withInheritance(this.includeInheritance).withExamples(this.includeExamples).withExtensionGuide(this.includeExtensionGuide);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create HTML documentation writer", e);
        }
    }

    public void setVersion(String version) {
        this.version = version;
        log.debug("Set documentation version to: {}", (Object)version);
    }

    public void setTitle(String title) {
        this.title = title;
        log.debug("Set documentation title to: {}", (Object)title);
    }

    public void setIncludeInheritance(boolean includeInheritance) {
        this.includeInheritance = includeInheritance;
        log.debug("Set includeInheritance to: {}", (Object)includeInheritance);
    }

    public void setIncludeExamples(boolean includeExamples) {
        this.includeExamples = includeExamples;
        log.debug("Set includeExamples to: {}", (Object)includeExamples);
    }

    public void setIncludeExtensionGuide(boolean includeExtensionGuide) {
        this.includeExtensionGuide = includeExtensionGuide;
        log.debug("Set includeExtensionGuide to: {}", (Object)includeExtensionGuide);
    }

    @Override
    public String toString() {
        return "MetaDataHtmlDocumentationGenerator{version='" + this.version + "', title='" + this.title + "', includeInheritance=" + this.includeInheritance + ", includeExamples=" + this.includeExamples + ", includeExtensionGuide=" + this.includeExtensionGuide + "}";
    }

    public String getConfigurationSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("HTML Documentation Generator Configuration:\n");
        summary.append("  Title: ").append(this.title).append("\n");
        summary.append("  Version: ").append(this.version).append("\n");
        summary.append("  Inheritance Analysis: ").append(this.includeInheritance ? "Enabled" : "Disabled").append("\n");
        summary.append("  Usage Examples: ").append(this.includeExamples ? "Enabled" : "Disabled").append("\n");
        summary.append("  Extension Guide: ").append(this.includeExtensionGuide ? "Enabled" : "Disabled");
        return summary.toString();
    }

    public static void registerHtmlDocAttributes(MetaDataRegistry registry) {
        registry.findType("object", "base").optionalAttribute(HTML_TITLE, "string").optionalAttribute(HTML_DESCRIPTION, "string").optionalAttribute(HTML_EXAMPLE, "string").optionalAttribute(HTML_USAGE_PATTERN, "string").optionalAttribute(HTML_EXTENSION_GUIDE, "string").optionalAttribute(HTML_SEE_ALSO, "string").optionalAttribute(HTML_SINCE_VERSION, "string").optionalAttribute(HTML_DEPRECATED, "string");
        registry.findType("field", "base").optionalAttribute(HTML_TITLE, "string").optionalAttribute(HTML_DESCRIPTION, "string").optionalAttribute(HTML_EXAMPLE, "string").optionalAttribute(HTML_USAGE_PATTERN, "string").optionalAttribute(HTML_SEE_ALSO, "string").optionalAttribute(HTML_SINCE_VERSION, "string").optionalAttribute(HTML_DEPRECATED, "string");
        registry.findType("field", "string").optionalAttribute(HTML_EXAMPLE, "string").optionalAttribute(HTML_USAGE_PATTERN, "string");
        registry.findType("field", "int").optionalAttribute(HTML_EXAMPLE, "string").optionalAttribute(HTML_USAGE_PATTERN, "string");
        log.info("Registered HTML documentation attributes for enhanced type documentation");
    }
}

